create table t_sync_app_address
(
  id             varchar(32) not null,
  app_id                    varchar2(128),
  app_regionalism_code                 varchar2(64),
  network_area_code   varchar2(1),
  app_url   varchar2(1024),
  app_proxy_url   varchar2(1024),
  app_proxy_port  varchar2(1024),
  update_time               number(20),
  app_url_type   varchar2(1),
  app_url_num               number(11)
);
comment on table t_sync_app_address is '应用地址及代理地址信息表';
comment on column t_sync_app_address.id is '主键id';
comment on column t_sync_app_address.app_id is '应用id';
comment on column t_sync_app_address.app_regionalism_code is '应用所属行政区划编码';
comment on column t_sync_app_address.network_area_code is '应用所属网络区划编码';
comment on column t_sync_app_address.app_url is '应用的真实地址';
comment on column t_sync_app_address.app_proxy_url is '应用的代理地址';
comment on column t_sync_app_address.app_proxy_port is '应用的代理地址端口';
comment on column t_sync_app_address.update_time is '更新时间';
comment on column t_sync_app_address.app_url_type is '应用地址类型，1：主页地址，2：子页面地址';
comment on column t_sync_app_address.app_url_num is '应用地址类型，顺序';
alter table t_sync_app_address add primary key (app_address_id);
