/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.PersonAppSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PersonAppSyncDaoImpl
implements PersonAppSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(PersonAppSyncDaoImpl.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void savePersonApp(List<SyncPersonApp> listPersonApp) {
        String sql = "INSERT INTO t_sync_person_app (PERSON_APP_ID, APP_ID, APP_REGIONALISM_CODE, APP_NETWORK_CODE, PERSON_ID, PERSON_REGIONALISM_CODE, CREATE_TIME, LAST_UPDATE_TIME, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonApp personApp : listPersonApp) {
            Object[] args = new Object[]{personApp.getPersonAppId(), personApp.getAppId(), personApp.getAppRegionalismCode(), personApp.getAppNetworkCode(), personApp.getPersonId(), personApp.getPersonRegionalismCode(), personApp.getCreateTime(), personApp.getLastUpdateTime(), personApp.getStatus()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void savePersonApp(SyncPersonApp personApp) {
        this.savePersonApp(Arrays.asList(personApp));
    }

    @Override
    public void updatePersonAppStatus(SyncPersonApp syncPersonApp) {
        this.updatePersonAppStatus(Arrays.asList(syncPersonApp));
    }

    @Override
    public void updatePersonAppStatusById(SyncPersonApp syncPersonApp) {
        String sql = "UPDATE t_sync_person_app SET status = ?, LAST_UPDATE_TIME = ? where PERSON_APP_ID = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{syncPersonApp.getStatus(), syncPersonApp.getLastUpdateTime(), syncPersonApp.getPersonAppId()});
    }

    @Override
    public void updatePersonAppStatus(List<SyncPersonApp> listPersonApp) {
        String sql = "UPDATE t_sync_person_app SET status = ?, LAST_UPDATE_TIME = ? where app_id = ?  and app_regionalism_Code = ?  and person_id = ?  and person_regionalism_Code = ? ";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonApp syncPersonApp : listPersonApp) {
            Object[] args = new Object[]{syncPersonApp.getStatus(), syncPersonApp.getLastUpdateTime(), syncPersonApp.getAppId(), syncPersonApp.getAppRegionalismCode(), syncPersonApp.getPersonId(), syncPersonApp.getPersonRegionalismCode()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void deletePersonAppByAppId(String appId, String appRegionalismCode) {
        String sql = "DELETE FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{appId, appRegionalismCode});
    }

    @Override
    public Long queryPersonAppCountByAppId(String appId, String appRegionalismCode) {
        String sql = "SELECT count(1) FROM t_sync_person_app WHERE app_id = ?  AND app_regionalism_Code = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(appId);
        args.add(appRegionalismCode);
        Long count = (Long)this.basicSyncCommonDao.selectOne(sql, args.toArray(), Long.class);
        return count;
    }

    @Override
    public Long queryPersonAppCountByAppId(String appId, String appRegionalismCode, Integer status) {
        String sql = "SELECT count(1) FROM t_sync_person_app WHERE app_id = ?  AND app_regionalism_Code = ? ";
        Object[] args = new Object[]{appId, appRegionalismCode};
        if (null != status) {
            sql = sql + " AND status = ? ";
            args = new Object[]{appId, appRegionalismCode, status};
        }
        Long count = (Long)this.basicSyncCommonDao.selectOne(sql, args, Long.class);
        return count;
    }

    @Override
    public List<SyncPersonApp> queryPersonAppByAppId(String appId, String appRegionalismCode) {
        String sql = "SELECT * FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncPersonApp.class);
    }

    @Override
    public List<SyncPersonApp> queryPersonAppByAppId(String appId, String appRegionalismCode, Integer status) {
        String sql = "SELECT * FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        Object[] args = new Object[]{appId, appRegionalismCode};
        if (null != status) {
            sql = sql + " AND status = ? ";
            args = new Object[]{appId, appRegionalismCode, status};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncPersonApp.class);
    }

    @Override
    public List<SyncPersonApp> queryPersonAppByAppId(String appId, String appRegionalismCode, Page page) {
        String sql = "SELECT * FROM t_sync_person_app  where app_id = ?  and app_regionalism_Code = ? ";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncPersonApp.class, page);
    }

    @Override
    public List<SyncPersonApp> querySyncPersonAppListByPersonId(String personId, String personRegionalismCode) {
        String sql = "SELECT * FROM t_sync_person_app  where person_id = ? ";
        Object[] args = new Object[]{personId};
        if (!StringUtils.isEmpty((Object)personRegionalismCode)) {
            sql = sql + " and person_regionalism_Code = ? ";
            args = new Object[]{personId, personRegionalismCode};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncPersonApp.class);
    }

    @Override
    public boolean existPersonAppPower(String personId, String personRegionalismCode, String appId, String appRegionalismCode) {
        Long count;
        String sql = "SELECT count(1) FROM t_sync_person_app WHERE person_id = ?  AND app_id = ?  AND status = ? ";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(personId);
        args.add(appId);
        args.add(SyncPersonApp.status_grant_1);
        if (!StringUtils.isEmpty((Object)personRegionalismCode)) {
            sql = sql + " AND person_regionalism_Code = ? ";
            args.add(personRegionalismCode);
        }
        if (!StringUtils.isEmpty((Object)appRegionalismCode)) {
            sql = sql + " AND app_regionalism_Code = ? ";
            args.add(appRegionalismCode);
        }
        return null != (count = (Long)this.basicSyncCommonDao.selectOne(sql, args.toArray(), Long.class)) && count > 0L;
    }

    @Override
    public SyncPersonApp getSyncPersonApp(String personId, String personRegionalismCode, String appId, String appRegionalismCode) {
        List<?> count;
        String sql = "SELECT * FROM t_sync_person_app WHERE person_id = ?  AND app_id = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(personId);
        args.add(appId);
        if (!StringUtils.isEmpty((Object)personRegionalismCode)) {
            sql = sql + " AND person_regionalism_Code = ? ";
            args.add(personRegionalismCode);
        }
        if (!StringUtils.isEmpty((Object)appRegionalismCode)) {
            sql = sql + " AND app_regionalism_Code = ? ";
            args.add(appRegionalismCode);
        }
        return null != (count = this.basicSyncCommonDao.selectList(sql, args.toArray(), SyncPersonApp.class)) && count.size() > 0 ? (SyncPersonApp)count.get(0) : null;
    }

    @Override
    public boolean existPersonAppPower(String personId, String appId) {
        return this.existPersonAppPower(personId, appId);
    }

    @Override
    public void deletePersonAppById(List<Long> listPersonId) {
        if (!CollectionUtils.isEmpty(listPersonId)) {
            for (Long id : listPersonId) {
                this.deletePersonAppById(id);
            }
        }
    }

    @Override
    public void deletePersonAppById(Long personAppId) {
        String sql = "DELETE FROM t_sync_person_app  WHERE PERSON_APP_ID = ? ";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{personAppId});
    }
}

