/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.sync.bean.AppAddressBean;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.AppAddressSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AppAddressSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppAddressSyncHandler.class);
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private Environment environment;
    @Autowired
    private AppAddressSyncDao appAddressSyncDao;
    private Long syncAppAddressInterval;
    private String syncAppAddressSwitch;
    private String syncAppAddressApp_key = "sync.appAddress.app";
    private volatile boolean syncAppAddressRunning = false;

    @Override
    String getPoolName() {
        return "appAddress";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        this.syncAppAddressSwitch = this.environment.getProperty("sync.appAddress.switch", "on");
        if ("off".equalsIgnoreCase(this.syncAppAddressSwitch)) {
            logger.info("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.appAddress.switch=on");
            return;
        }
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        String property = this.environment.getProperty("sync.appAddress.interval", "300");
        this.syncAppAddressInterval = Long.parseLong(property);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.appAddress.interval[{}]\u79d2", (Object)this.syncAppAddressInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP_ADDRESS.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncAppAddress();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncAppAddressInterval, TimeUnit.SECONDS);
    }

    @Transactional(rollbackFor={Exception.class})
    public int syncAppAddress() {
        List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
        return this.syncAppAddress(listSyncApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncAppAddress(List<SyncApp> listSyncApp) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncAppAddressKey();
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            AppAddressSyncHandler appAddressSyncHandler = this;
            synchronized (appAddressSyncHandler) {
                if (this.syncAppAddressRunning) {
                    logger.error("\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncAppAddressRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            String syncAppAddressApp;
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,\u5e94\u7528:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncApp));
            }
            if (!StringUtils.isEmpty((Object)(syncAppAddressApp = this.environment.getProperty(this.syncAppAddressApp_key, "")))) {
                String[] ary = syncAppAddressApp.split(",");
                List<String> listAppId = Arrays.asList(ary);
                ArrayList<SyncApp> listSyncAppTmp = new ArrayList<SyncApp>();
                for (SyncApp syncApp : listSyncApp) {
                    String appRegionalismCode = syncApp.getAppId();
                    if (!listAppId.contains(appRegionalismCode)) continue;
                    listSyncAppTmp.add(syncApp);
                }
                listSyncApp = listSyncAppTmp;
            }
            for (SyncApp syncApp : listSyncApp) {
                String appId = syncApp.getAppId();
                String appRegionalismCode = syncApp.getRegionalismCode();
                String appNetworkAreaCode = syncApp.getNetworkAreaCode();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appId:\u3010{}\u3011,appRegionalismCode:\u3010{}\u3011>>>", (Object)appId, (Object)appRegionalismCode);
                }
                int addCount = 0;
                int deleteCount = 0;
                try {
                    List<AppAddressBean> listPullSyncAppAddressBean = this.pullAppAddressList(appId, appRegionalismCode, appNetworkAreaCode);
                    if (null == listPullSyncAppAddressBean || listPullSyncAppAddressBean.isEmpty()) {
                        logger.info("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)appId, (Object)appRegionalismCode);
                        List<AppAddressBean> listAppAddressBean = this.appAddressSyncDao.getAppAddressByAppId(appId, appRegionalismCode, AppAddressBean.status_grant_1);
                        for (AppAddressBean appAddressBean : listAppAddressBean) {
                            appAddressBean.setStatus(AppAddressBean.status_delete_3);
                            appAddressBean.setUpdateTime(System.currentTimeMillis());
                            this.appAddressSyncDao.updateAppAddressStatusById(appAddressBean);
                            ++deleteCount;
                        }
                    } else {
                        HashMap<Object, AppAddressBean> mapPullAppAddressBean = new HashMap<Object, AppAddressBean>();
                        for (AppAddressBean appAddressBean : listPullSyncAppAddressBean) {
                            appAddressBean.setId(IdGeneratorUtil.nextIdStr());
                            appAddressBean.setAppId(appId);
                            appAddressBean.setAppRegionalismCode(appRegionalismCode);
                            appAddressBean.setNetworkAreaCode(appNetworkAreaCode);
                            String key = appAddressBean.getAppId() + appAddressBean.getAppRegionalismCode() + appAddressBean.getAppUrl() + appAddressBean.getAppProxyUrl();
                            mapPullAppAddressBean.put(key, appAddressBean);
                        }
                        List<AppAddressBean> listDbAppAddressBean = this.appAddressSyncDao.getAppAddressByAppId(appId, appRegionalismCode);
                        HashMap<String, AppAddressBean> mapDbAppAddressBean = new HashMap<String, AppAddressBean>();
                        if (null != listDbAppAddressBean && !listDbAppAddressBean.isEmpty()) {
                            for (AppAddressBean appAddressBean : listDbAppAddressBean) {
                                String key = appAddressBean.getAppId() + appAddressBean.getAppRegionalismCode() + appAddressBean.getAppUrl() + appAddressBean.getAppProxyUrl();
                                mapDbAppAddressBean.put(key, appAddressBean);
                            }
                        }
                        MapDifference difference = Maps.difference(mapPullAppAddressBean, mapDbAppAddressBean);
                        Map mapAdd = difference.entriesOnlyOnLeft();
                        Map mapDelete = difference.entriesOnlyOnRight();
                        Map mapCommonKey = difference.entriesDiffering();
                        if (!CollectionUtils.isEmpty((Map)mapAdd)) {
                            for (AppAddressBean appAddressBean : mapAdd.values()) {
                                AppAddressBean appAddressTmp = this.appAddressSyncDao.getAppAddress(appId, appRegionalismCode, appAddressBean.getAppUrl(), appAddressBean.getAppProxyUrl());
                                if (null == appAddressTmp) {
                                    appAddressBean.setUpdateTime(System.currentTimeMillis());
                                    appAddressBean.setStatus(AppAddressBean.status_grant_1);
                                    this.appAddressSyncDao.saveSyncAppAddress(appAddressBean);
                                    continue;
                                }
                                appAddressTmp.setUpdateTime(System.currentTimeMillis());
                                appAddressTmp.setStatus(AppAddressBean.status_grant_1);
                                this.appAddressSyncDao.updateAppAddressStatusById(appAddressTmp);
                            }
                            addCount = mapAdd.size();
                        }
                        if (!CollectionUtils.isEmpty((Map)mapDelete)) {
                            for (AppAddressBean appAddressBean : mapDelete.values()) {
                                if (AppAddressBean.status_grant_1.intValue() != appAddressBean.getStatus().intValue()) continue;
                                appAddressBean.setUpdateTime(System.currentTimeMillis());
                                appAddressBean.setStatus(AppAddressBean.status_delete_3);
                                this.appAddressSyncDao.updateAppAddressStatusById(appAddressBean);
                                ++deleteCount;
                            }
                        }
                        logger.info("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{appId, appRegionalismCode, addCount, deleteCount});
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<", (Object)appId, (Object)appRegionalismCode);
                }
                if (!existRedis) continue;
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncAppAddressRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    private List<AppAddressBean> computeDeleteAppAddressBean(Map<String, AppAddressBean> mapPullAppAddressBean, Map<String, AppAddressBean> mapDbAppAddressBean) {
        ArrayList<AppAddressBean> listDeleteAppAddressBean = new ArrayList<AppAddressBean>();
        for (Map.Entry<String, AppAddressBean> entry : mapDbAppAddressBean.entrySet()) {
            String key = entry.getKey();
            if (mapPullAppAddressBean.containsKey(key)) continue;
            AppAddressBean syncAppResource = entry.getValue();
            listDeleteAppAddressBean.add(syncAppResource);
        }
        return listDeleteAppAddressBean;
    }

    private List<AppAddressBean> computeUpdateSyncAppResource(Map<String, AppAddressBean> mapPullAppAddressBean, Map<String, AppAddressBean> mapDbAppAddressBean) {
        ArrayList<AppAddressBean> listUpdateAppAddressBean = new ArrayList<AppAddressBean>();
        for (Map.Entry<String, AppAddressBean> entry : mapPullAppAddressBean.entrySet()) {
            String key = entry.getKey();
            if (!mapDbAppAddressBean.containsKey(key)) continue;
            AppAddressBean appAddressBean = mapDbAppAddressBean.get(key);
            listUpdateAppAddressBean.add(appAddressBean);
        }
        return listUpdateAppAddressBean;
    }

    private List<AppAddressBean> computeAddAppAddressBean(Map<String, AppAddressBean> mapPullAppAddressBean, Map<String, AppAddressBean> mapDbAppAddressBean) {
        ArrayList<AppAddressBean> listAddSyncAppResource = new ArrayList<AppAddressBean>();
        for (Map.Entry<String, AppAddressBean> entry : mapPullAppAddressBean.entrySet()) {
            String key = entry.getKey();
            if (mapDbAppAddressBean.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            AppAddressBean appAddressBean = entry.getValue();
            listAddSyncAppResource.add(appAddressBean);
        }
        return listAddSyncAppResource;
    }

    public List<AppAddressBean> pullAppAddressList(String appId, String appRegionalismCode, String appNetworkAreaCode) {
        HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
        mapReqParam.put("appRegionalismCode", appRegionalismCode);
        mapReqParam.put("appId", appId);
        String localNetworkCode = Consts.local_networkAreaCode;
        List<AppAddressBean> listAppAddress = this.queryOffsiteAppAddressList(appRegionalismCode, localNetworkCode, mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, null != listAppAddress ? JSON.toJSONString(listAppAddress) : null});
        }
        return listAppAddress;
    }

    private List<AppAddressBean> queryOffsiteAppAddressList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_RSB_SVC_101.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,appAddress:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new ArrayList<AppAddressBean>();
        }
        try {
            return JSONArray.parseArray((String)json, AppAddressBean.class);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528\u4ee3\u7406\u5730\u5740\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP_ADDRESS != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

