package com.xdja.ca.monitor.bean;

import com.xdja.ca.monitor.util.BigDecimalUtil;

/**
 * disk data
 *
 * @author liutao
 * @date 2020/6/30
 */
public class DiskData {
	/**
	 * disk total space
	 */
	private Long total;
	/**
	 * disk use space
	 */
	private Long use;
	/**
	 * disk usage
	 */
	private Double usage;

	public DiskData() {
	}

	public DiskData(long total, long use) {
		this.total = total;
		this.use = use;
		this.usage = BigDecimalUtil.div(use, total).doubleValue();
	}

	public Long getTotal() {
		return total;
	}

	public void setTotal(Long total) {
		this.total = total;
	}

	public Long getUse() {
		return use;
	}

	public void setUse(Long use) {
		this.use = use;
	}

	public Double getUsage() {
		return usage;
	}

	public void setUsage(Double usage) {
		this.usage = usage;
	}

	@Override
	public String toString() {
		return "DiskData{" +
				"total=" + total +
				", use=" + use +
				", usage=" + usage +
				'}';
	}
}
