package com.xdja.ca.monitor.collector;

import com.xdja.ca.monitor.bean.CpuData;
import com.xdja.ca.monitor.util.MonitorUtil;

import java.math.BigDecimal;

/**
 * cpu dataCollector
 *
 * @author liutao
 * @date 2020/6/30
 */
public class CpuDataCollector extends AbstractCollector<CpuData> {
	@Override
	void process(CollectCallBack<CpuData> callBack) {
		int osType = getOsType();
		try {
			if (osType == OS_TYPE_LINUX) {
				double cpuRate = MonitorUtil.monitorCpuRateForLinux().setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
				CpuData cpuData = new CpuData(cpuRate, System.currentTimeMillis());
				if (callBack != null) {
					callBack.onSuccess(cpuData);
				}
			} else {
				CpuData cpuData = MonitorUtil.monitorCpuByJdk();
				if (callBack != null) {
					callBack.onSuccess(cpuData);
				}
			}
		} catch (Exception e) {
			if (callBack != null) {
				callBack.onError("CpuData collector error,msg:" + e.getMessage());
			}
			e.printStackTrace();
		}
	}
}
