package com.xdja.ca.monitor.collector;

import com.xdja.ca.monitor.bean.DiskData;
import com.xdja.ca.monitor.util.MonitorUtil;

/**
 * disk data collector
 *
 * @author liutao
 * @date 2020/6/30
 */
public class DiskDataCollector extends AbstractCollector<DiskData> {
	@Override
	void process(CollectCallBack<DiskData> callBack) {
		try {
			DiskData diskData = MonitorUtil.monitorDiskData();
			if (callBack != null) {
				callBack.onSuccess(diskData);
			}
		} catch (Exception e) {
			if (callBack != null) {
				callBack.onError("DiskData collector error,msg:" + e.getMessage());
			}
			e.printStackTrace();
		}
	}
}
