package com.xdja.ca.monitor.factory;

import com.xdja.ca.monitor.bean.*;
import com.xdja.ca.monitor.collector.*;

/**
 * Created by liutao on 2020/6/30.<br>
 * collector factory
 */
public class CollectorFactory {
	public static <T> Collector<T> createCollector(Class<T> tClass) {
		Collector collector = null;
		if (tClass == CpuData.class) {
			collector = new CpuDataCollector();
		} else if (tClass == DiskData.class) {
			collector = new DiskDataCollector();
		} else if (tClass == MemoryData.class) {
			collector = new MemoryDataCollector();
		} else if (tClass == NicData.class) {
			collector = new NicDataCollector();
		} else if (tClass == SystemRuntimeData.class) {
			collector = new SystemRuntimeDataCollector();
		}
		return collector;
	}
}
