/*
 * Copyright 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xdja.camera2videolibrary;

import android.app.Activity;
import android.hardware.camera2.CameraAccessException;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.view.View;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class Camera2Fragment extends BaseFragment {

    /**
     * camera2 管理类
     */
    private Camera2Manager manager;

    public static Camera2Fragment newInstance() {
        return new Camera2Fragment();
    }

    public static Camera2Fragment newInstance(CameraParams cameraParams, int currentNum) {
        Camera2Fragment fragment = new Camera2Fragment();

        Bundle args = new Bundle();
        args.putSerializable("cameraParams", cameraParams); //拍摄参数
        args.putInt("currentNum", currentNum); //已拍摄多少个视频/照片
        fragment.setArguments(args);

        return fragment;
    }

    @Override
    public void onViewCreated(final View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        manager = new Camera2Manager(getActivity(), mTextureView);
    }

    @Override
    public void onResume() {
        manager.startBackgroundThread();
        super.onResume();
    }

    @Override
    public void onPause() {
        manager.closeDriver();
        manager.stopBackgroundThread();
        super.onPause();
    }

    @Override
    protected void startRecordingVideo(String path) {
        manager.startRecordingVideo(path);
    }

    @Override
    protected void takePicture(PictureCallback pictureCallback) {
        manager.takePicture(pictureCallback, null);
    }

    @Override
    protected void stopRecordingVideo() {
        manager.stopRecordingVideo();
    }

    @Override
    protected void openCamera(Activity activity, int width, int height) {
        try {
            manager.openDriver(activity, width, height);
        } catch (CameraAccessException e) {
//            Toast.makeText(activity, "Cannot access the camera.", Toast.LENGTH_SHORT).show();
            activity.finish();
        } catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.");
        }
    }

    @Override
    protected void configureTransform(int width, int height) {
        manager.configureTransform(width, height);
    }

    @Override
    protected boolean toggleFlash() {
        return manager.toggleFlash();
    }

    @Override
    protected void switchCamera() {
        try {
            manager.switchCamera();
        } catch (CameraAccessException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void startPreview() {
        manager.startPreview();
    }

    @Override
    protected void stopPreview() {

    }
}
