package com.xdja.camera2videolibrary;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;

import java.io.IOException;

@SuppressWarnings("deprecation")
public class CameraFragment extends BaseFragment {

    private String TAG = CameraFragment.class.getSimpleName();

    /**
     * camera 管理类
     */
    private CameraManager manager;

    public static CameraFragment newInstance() {
        return new CameraFragment();
    }

    public static CameraFragment newInstance(CameraParams cameraParams, int currentNum) {
        CameraFragment fragment = new CameraFragment();

        Bundle args = new Bundle();
        args.putSerializable("cameraParams", cameraParams); //拍摄参数
        args.putInt("currentNum", currentNum); //已拍摄多少个视频/照片
        fragment.setArguments(args);

        return fragment;
    }

    @Override
    public void onViewCreated(final View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        manager = new CameraManager(getActivity(), mTextureView);
    }

    @Override
    public void onPause() {
        manager.stopPreview();
        manager.closeDriver();
        super.onPause();
    }

    @Override
    protected void startRecordingVideo(String path) {
        manager.startRecordingVideo(path);
    }

    @Override
    protected void stopRecordingVideo() {
        manager.stopRecordingVideo();
        manager.stopPreview();
    }

    @Override
    protected void takePicture(PictureCallback pictureCallback) {
        manager.takePicture(pictureCallback);
    }

    @Override
    protected void openCamera(Activity activity, int width, int height) {
        try {
            manager.openDriver(activity, width, height);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.");
        }
    }

    @Override
    protected void configureTransform(int width, int height) {
        manager.configureTransform(width, height);
    }

    @Override
    protected boolean toggleFlash() {
        return manager.toggleFlash();
    }

    @Override
    protected void switchCamera() {
        try {
            manager.switchCamera();
        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void startPreview() {
        manager.startPreview();
    }

    @Override
    protected void stopPreview() {
        manager.stopPreview();
    }
}
