package com.xdja.camera2videolibrary;

import com.xdja.camera2videolibrary.utils.CameraUtils;

import java.io.Serializable;

/**
 * Created by wanjing on 2017/11/7.
 */

public class CameraParams implements Serializable {

    private int max = 10000; //短视频最大录制时间，默认10000ms
    private int maxNum = 1; // 最多拍摄多少个视频/照片, 默认一张
    private boolean hide = false; //是否隐藏头部布局，包含开关闪光灯+切换摄像头按钮，默认不隐藏
    private String fileDir; //保存的视频/照片存储目录，默认getExternalFilesDir(null)
    private int type = CameraUtils.TYPE_PICTURE_AND_VIDEO; //拍摄类型 0：照片和短视频，1：照片 2：短视频 默认type==0

    public int getMax() {
        return max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMaxNum() {
        return maxNum;
    }

    public void setMaxNum(int maxNum) {
        this.maxNum = maxNum;
    }

    public boolean isHide() {
        return hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String getFileDir() {
        return fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }
}
