package com.xdja.camera2videolibrary.utils;

import android.Manifest;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v13.app.FragmentCompat;
import android.support.v4.content.PermissionChecker;

import com.xdja.camera2videolibrary.R;

/**
 * Created by wanjing on 2017/10/24.
 *
 * desc: 动态权限申请工具类
 */

public class PermissionUtils {

    public static final int REQUEST_VIDEO_PERMISSIONS = 1;
    public static final String FRAGMENT_DIALOG = "dialog";

    public static final String[] VIDEO_PERMISSIONS = {
            Manifest.permission.CAMERA,
            Manifest.permission.RECORD_AUDIO,
    };

    /**
     * Gets whether you should show UI with rationale for requesting permissions.
     *
     * @param permissions The permissions your app wants to request.
     * @return Whether you can show permission rationale UI.
     */
    private static boolean shouldShowRequestPermissionRationale(Fragment fragment, String[] permissions) {
        for (String permission : permissions) {
            if (FragmentCompat.shouldShowRequestPermissionRationale(fragment, permission)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Requests permissions needed for recording video.
     */
    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
    public static void requestVideoPermissions(Fragment fragment) {
        if (shouldShowRequestPermissionRationale(fragment, VIDEO_PERMISSIONS)) {
            new ConfirmationDialog().show(fragment.getChildFragmentManager(), FRAGMENT_DIALOG);
        } else {
            FragmentCompat.requestPermissions(fragment, VIDEO_PERMISSIONS, REQUEST_VIDEO_PERMISSIONS);
        }
    }

    public static boolean hasPermissionsGranted(Context context, String[] permissions) {
        for (String permission : permissions) {
            // modify by wanjing on 2017/10/18 17:35
            // 只有PermissionChecker.checkSelfPermission方法检测正确
            if (PermissionChecker.checkSelfPermission(context, permission)
                    != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
            // end modify on 2017/10/18 17:35.
        }
        return true;
    }

    public static class ConfirmationDialog extends DialogFragment {

        @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            final Fragment parent = getParentFragment();
            return new AlertDialog.Builder(getActivity())
                    .setMessage(R.string.permission_request)
                    .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            FragmentCompat.requestPermissions(parent, VIDEO_PERMISSIONS,
                                    REQUEST_VIDEO_PERMISSIONS);
                        }
                    })
                    .setNegativeButton(android.R.string.cancel,
                            new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    parent.getActivity().finish();
                                }
                            })
                    .create();
        }
    }
}
