package com.xdja.camera2videolibrary;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;

import com.xdja.camera2videolibrary.utils.CameraUtils;

public class CameraActivity extends Activity {

    private static final String TAG = CameraActivity.class.getSimpleName();

    private ICameraCallBack cameraCallBack = new ICameraCallBack() {
        @Override
        public void onComplete(Bitmap bitmap) {
            Log.i(TAG, "ICameraCallBack: onComplete()");
        }

        @Override
        public void onFinish(String filePath) {
            Log.i(TAG, "ICameraCallBack: onFinish()");
        }

        @Override
        public void onReTake() {
            Log.i(TAG, "ICameraCallBack: onReTake()");
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_camera);

        Bundle bundle = getIntent().getExtras();
        if (bundle == null) {
            return;
        }
        CameraParams cameraParams = (CameraParams) bundle
                .getSerializable(CameraUtils.EXTRA_CAMERA_PARAMS);
        if (cameraParams == null) {
            cameraParams = new CameraParams();
        }
        if (cameraParams.getMethod() == CameraUtils.METHOD_CAMERA2
                && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Camera2Fragment camera2Fragment = Camera2Fragment
                    .newInstance(cameraParams);
            camera2Fragment.setCameraCallBack(cameraCallBack);
            getFragmentManager().beginTransaction()
                    .replace(R.id.container, camera2Fragment)
                    .commit();
        } else {
            CameraFragment cameraFragment = CameraFragment
                    .newInstance(cameraParams);
            cameraFragment.setCameraCallBack(cameraCallBack);
            getFragmentManager().beginTransaction()
                    .replace(R.id.container, cameraFragment)
                    .commit();
        }
    }
}
