package com.xdja.camera2videolibrary;

import com.xdja.camera2videolibrary.utils.CameraUtils;

import java.io.Serializable;

/**
 * Created by wanjing on 2017/11/7.
 */

public class CameraParams implements Serializable {

    //默认调起使用Camera API的CameraFragment.
    private int method = 0;
    //已拍摄多少个视频/照片， 默认一张
    private int currentNum = 0;
    // 最多拍摄多少个视频/照片, 默认一张
    private int maxNum = 1;
    //是否隐藏头部布局，包含开关闪光灯+切换摄像头按钮，默认不隐藏
    private boolean hide = false;
    //保存的视频/照片存储目录，默认getExternalFilesDir(null)
    private String fileDir;
    //拍摄类型 0：照片和短视频，1：照片 2：短视频 默认type==0
    private int type = CameraUtils.TYPE_PICTURE_AND_VIDEO;
    //短视频最大录制时间，默认10000ms
    private int max = 10000;
    //全部拍摄完成是否关闭相机界面
    private boolean completedFinish = true;

    private int pictureMaxValue = 4000 * 3000;
    private int pictureMinValue = 1600 * 1200;
    private int videoMaxValue = 1920 * 1080;
    private int videoMinValue = 800 * 480;

    public int getMethod() {
        return method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public int getCurrentNum() {
        return currentNum;
    }

    public void setCurrentNum(int currentNum) {
        this.currentNum = currentNum;
    }

    public int getMaxNum() {
        return maxNum;
    }

    public void setMaxNum(int maxNum) {
        this.maxNum = maxNum;
    }

    public boolean isHide() {
        return hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String getFileDir() {
        return fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getMax() {
        return max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public boolean isCompletedFinish() {
        return completedFinish;
    }

    public void setCompletedFinish(boolean completedFinish) {
        this.completedFinish = completedFinish;
    }

    public int getPictureMaxValue() {
        return pictureMaxValue;
    }

    public void setPictureMaxValue(int pictureMaxValue) {
        this.pictureMaxValue = pictureMaxValue;
    }

    public int getPictureMinValue() {
        return pictureMinValue;
    }

    public void setPictureMinValue(int pictureMinValue) {
        this.pictureMinValue = pictureMinValue;
    }

    public int getVideoMaxValue() {
        return videoMaxValue;
    }

    public void setVideoMaxValue(int videoMaxValue) {
        this.videoMaxValue = videoMaxValue;
    }

    public int getVideoMinValue() {
        return videoMinValue;
    }

    public void setVideoMinValue(int videoMinValue) {
        this.videoMinValue = videoMinValue;
    }
}
