package com.xdja.camera2videolibrary.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.text.TextUtils;
import android.util.Log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CameraUtils {

    private static String TAG = CameraUtils.class.getSimpleName();

    public static final String EXTRA_CAMERA_PARAMS = "extra_camera_params";

    public static final String EXTRA_CAMERA_RESULTS = "extra_camera_results";

    public static final int METHOD_CAMERA = 0;

    public static final int METHOD_CAMERA2 = 1;

    public static final int TYPE_PICTURE_AND_VIDEO = 0;

    public static final int TYPE_ONLY_PICTURE = 1;

    public static final int TYPE_ONLY_VIDEO = 2;

    private static String mFileDir;

    public static void setFileDir(Context context, String fileDir) {
        if (TextUtils.isEmpty(fileDir)) {
            mFileDir = getExternalFilesDir(context);
        } else {
            mFileDir = fileDir;
        }
    }

    public static String getFileDir() {
        return mFileDir;
    }

    public static String getExternalFilesDir(Context context) {
        File dir = context.getExternalFilesDir(null);
        return dir == null ? "" : (dir.getAbsolutePath());
    }

    public static String getPictureFilePath(Context context) {
        File picDir = new File(getFileDir() + "/pic/");
        if (picDir.exists() || picDir.mkdirs()) {
            return picDir.getAbsolutePath() + "/" + System.currentTimeMillis() + ".jpg";
        } else {
            return getExternalFilesDir(context) + "/" + System.currentTimeMillis() + ".jpg";
        }
    }

    public static String getVideoFilePath(Context context) {
        File videoDir = new File(getFileDir() + "/video/");
        if (videoDir.exists() || videoDir.mkdirs()) {
            return videoDir.getAbsolutePath() + "/" + System.currentTimeMillis() + ".mp4";
        } else {
            return getExternalFilesDir(context) + "/" + System.currentTimeMillis() + ".mp4";
        }
    }

    public static String getVideoCacheFilePath(Context context) {
        File cacheDir = new File(getFileDir() + "/cache/");
        if (cacheDir.exists() || cacheDir.mkdirs()) {
            return cacheDir.getAbsolutePath() + "/" + System.currentTimeMillis() + ".mp4";
        } else {
            return getExternalFilesDir(context) + "/" + System.currentTimeMillis() + ".mp4";
        }
    }

    public static Bitmap bytes2Bitmap(byte[] data, int degrees) {
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeByteArray(data, 0, data.length);

            Bitmap bitmapRotate;
            Matrix matrix = new Matrix();
            matrix.reset();
            matrix.postRotate(degrees);
            bitmapRotate = Bitmap.createBitmap(bitmap, 0, 0,
                    bitmap.getWidth(), bitmap.getHeight(), matrix, true);
            bitmap = bitmapRotate;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static void savePic(Bitmap bitmap, String filePath) {
        if (bitmap == null) {
            return;
        }
        File pictureFile = new File(filePath);

        try {
            FileOutputStream fos = new FileOutputStream(pictureFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, bos);
            bos.flush();
            bos.close();
        } catch (FileNotFoundException e) {
            Log.d(TAG, "File not found: " + e.getMessage());
        } catch (IOException e) {
            Log.d(TAG, "Error accessing file: " + e.getMessage());
        }
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        return file.exists() && file.isFile() && file.delete();
    }

    public static boolean renameFile(String fromPath, String toPath) {
        File fromFile = new File(fromPath);
        if (fromFile.exists() && fromFile.isFile()) {
            File toFile = new File(toPath);
            return fromFile.renameTo(toFile);
        } else {
            return false;
        }
    }
}
