/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.environment;

import com.xjda.framework.agreement.central.environment.ProCenterException;
import com.xjda.framework.agreement.central.environment.PropertiesLoadHelper;
import com.xjda.framework.agreement.central.util.ConfigUtil;
import com.xjda.framework.agreement.central.util.EmptyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.StringUtils;
import sun.security.pkcs.ParsingException;

public class BeforeConfigFileApplicationListener
implements EnvironmentPostProcessor,
Ordered {
    private List<PropertySourceLoader> propertySourceLoaders;
    private ResourceLoader resourceLoader;
    private final DeferredLog logger = new DeferredLog();
    private static final String SPRING_CONFIG_NAME = "spring.config.name";
    private static final String[] DEFAULT_CONFIG_NAMES = new String[]{"system", "db"};
    private static final String[] DEFAULT_REFRESH_FILE_NAME = new String[]{"system..properties"};

    public int getOrder() {
        return -2147483639;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication springApplication) {
        Object[] configPaths;
        this.logger.switchTo(BeforeConfigFileApplicationListener.class);
        this.propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        this.resourceLoader = springApplication.getResourceLoader();
        this.resourceLoader = this.resourceLoader != null ? this.resourceLoader : new DefaultResourceLoader(this.getClass().getClassLoader());
        this.loadAppCenterConfigFile(environment);
        String configPath = environment.getProperty("spring.config.location");
        if (EmptyUtil.isEmpty(configPath)) {
            if (File.separatorChar == '\\') {
                configPath = environment.getProperty("config.path.windows");
            } else {
                if (File.separatorChar != '/') {
                    throw new ProCenterException("system property File.separatorChar[" + File.separatorChar + "] not support");
                }
                configPath = environment.getProperty("config.path.linux");
            }
            if (EmptyUtil.isNotEmpty(configPath)) {
                this.setSpringConfigLocationProperty(environment, configPath);
            }
        }
        if (EmptyUtil.isEmpty(configPath)) {
            this.logger.warn((Object)"\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u8def\u5f84\u3010file:./ \u6216 classpath:/\u3011");
            configPaths = new String[]{"file:./", "classpath:/"};
        } else {
            this.logger.warn((Object)("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u8def\u5f84\u3010" + configPath + "\u3011"));
            if (configPath.contains("$")) {
                configPath = environment.resolvePlaceholders(configPath);
            }
            configPaths = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)configPath));
        }
        Set<String> fileNames = this.fileNames((Environment)environment);
        System.out.println(Arrays.toString(configPaths));
        try {
            List<PropertySource<?>> listPropertySource = this.loadPropertySource(new HashSet<Object>(Arrays.asList(configPaths)), fileNames);
            listPropertySource.sort(Comparator.comparing(PropertySource::getName));
            this.addPropertySource(environment, listPropertySource);
            String logBackPath = this.getLogBackPath((String[])configPaths);
            System.out.println(logBackPath);
            String[] refreshFileParentLocation = this.refreshFileParentLocation((Environment)environment, (String[])configPaths);
            this.setSystemAndLoggerProFilePath(environment, refreshFileParentLocation, logBackPath);
            ConfigUtil.environment = environment;
            String logFilePath = File.separatorChar == '\\' ? "config.logfile.windows" : "config.logfile.linux";
            System.setProperty("logfile.path", ConfigUtil.getString(logFilePath));
            System.setProperty("spring.application.name", ConfigUtil.getString("spring.application.name"));
            System.setProperty("project.name", ConfigUtil.getString("spring.application.name"));
            System.out.println("-------------------------------\u7cfb\u7edf[" + System.getProperty("project.name") + "]\u521d\u59cb\u5316-------------------------------");
            String dbFilePath = configPath + "db.properties";
            System.setProperty("db.properties", dbFilePath);
            System.setProperty("datasource.properties", dbFilePath);
            System.out.println(" \u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6[" + dbFilePath + "]");
            for (String fileName : fileNames) {
                fileName = fileName + "." + ".properties";
                System.setProperty(fileName, configPath + fileName);
                System.out.println(" \u52a0\u8f7d\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f[" + fileName + "]");
            }
            String logbackFilePath = configPath + "logback-spring.xml";
            System.setProperty("logback.xml", logbackFilePath);
            System.setProperty("logfile.path", logbackFilePath);
            System.out.println(" \u52a0\u8f7d\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6logback.xml[" + logbackFilePath + "]");
        }
        catch (IOException e) {
            throw new ProCenterException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38:", e);
        }
    }

    private String[] refreshFileParentLocation(Environment environment, String[] configLocations) throws IOException {
        String refreshFileNames = environment.getProperty("config.enable-refresh-file-name");
        String[] refreshNameArray = EmptyUtil.isEmpty(refreshFileNames) ? DEFAULT_REFRESH_FILE_NAME : StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)refreshFileNames));
        ArrayList<String> listRefreshFile = new ArrayList<String>();
        HashSet<String> needRefreshPath = new HashSet<String>();
        String[] aryConfigLocation = configLocations;
        for (String configPath : aryConfigLocation) {
            configPath = this.clearPath(configPath);
            String[] aryRefreshName = refreshNameArray;
            for (int i = 0; i < aryRefreshName.length; ++i) {
                String refreshName = aryRefreshName[i];
                Resource resource = this.getResource(configPath + refreshName);
                if (resource == null || !resource.exists() || !resource.isFile()) continue;
                needRefreshPath.add(configPath);
            }
        }
        for (String refreshPath : needRefreshPath) {
            Resource resource = this.getResource(refreshPath);
            if (resource == null || !resource.exists()) continue;
            listRefreshFile.add(resource.getFile().getAbsolutePath());
        }
        return listRefreshFile.toArray(new String[0]);
    }

    private String getLogBackPath(String[] configPaths) throws IOException {
        String[] aryConfigPath;
        for (String path : aryConfigPath = configPaths) {
            Resource resource = this.getResource((path = this.clearPath(path)) + "logback-spring.xml");
            if (resource == null || !resource.exists() || !resource.isFile()) continue;
            return resource.getFile().getAbsolutePath();
        }
        throw new ParsingException("cannot found logback-spring.xml");
    }

    private List<PropertySource<?>> loadPropertySource(Set<String> locations, Set<String> fileNames) throws IOException {
        LinkedList list = new LinkedList();
        for (PropertySourceLoader propertySourceLoader : this.propertySourceLoaders) {
            list.addAll(this.load(propertySourceLoader, locations, fileNames));
        }
        return list;
    }

    private List<PropertySource<?>> load(PropertySourceLoader propertySourceLoader, Set<String> locations, Set<String> fileNames) throws IOException {
        String[] aryFileExtension;
        String[] fileExtensions = propertySourceLoader.getFileExtensions();
        HashSet<String> fullNames = new HashSet<String>();
        for (String extName : aryFileExtension = fileExtensions) {
            fullNames.addAll(this.fullNames(fileNames, extName));
        }
        LinkedList listPropertySourceResult = new LinkedList();
        for (String location : locations) {
            location = this.clearPath(location);
            for (String fullName : fullNames) {
                Resource resource = this.getResource(location + fullName);
                if (resource == null || !resource.exists() || !resource.isFile()) continue;
                List listPropertySource = propertySourceLoader.load(fullName, resource);
                listPropertySourceResult.addAll(listPropertySource);
            }
        }
        return listPropertySourceResult;
    }

    private Resource getResource(String location) {
        try {
            if (location.contains("*")) {
                throw new ProCenterException("location error [" + location + "] not support * ");
            }
            if (!location.startsWith("classpath:") && !location.startsWith("file:")) {
                location = "file:" + location;
            }
            return this.resourceLoader.getResource(location);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<String> fullNames(Set<String> fileNames, String ext) {
        HashSet<String> fullNames = new HashSet<String>();
        for (String fileName : fileNames) {
            fullNames.add(fileName + "." + ext);
        }
        return fullNames;
    }

    private Set<String> fileNames(Environment environment) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(Arrays.asList(DEFAULT_CONFIG_NAMES));
        result.addAll(this.fileNames(environment, "config.include-file-names"));
        result.addAll(this.fileNames(environment, "config.enable-refresh-file-name"));
        Set<String> evnConfigNames = this.evnConfigNames(environment);
        result.removeAll(evnConfigNames);
        return result;
    }

    private Set<String> fileNames(Environment environment, String key) {
        String fileNames = environment.getProperty(key);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (EmptyUtil.isEmpty(fileNames)) {
            return result;
        }
        if (!fileNames.contains(String.valueOf('\\')) && !fileNames.contains(String.valueOf('/'))) {
            String[] names;
            String[] aryFileName;
            System.setProperty(key, fileNames);
            for (String name : aryFileName = (names = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)fileNames)))) {
                if (null == name || "".equals(name.trim())) continue;
                if (name.contains(".")) {
                    name = name.substring(0, name.lastIndexOf("."));
                }
                result.add(name);
            }
            return result;
        }
        throw new ProCenterException("include file names error [\\ or /] not support!");
    }

    private Set<String> evnConfigNames(Environment environment) {
        if (environment.containsProperty(SPRING_CONFIG_NAME)) {
            String value = environment.getProperty(SPRING_CONFIG_NAME);
            List<String> list = Arrays.asList(StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)(value != null ? environment.resolvePlaceholders(value) : "application"))));
            return new LinkedHashSet<String>(list);
        }
        return new LinkedHashSet<String>();
    }

    private void addPropertySource(ConfigurableEnvironment environment, Collection<PropertySource<?>> propertySources) {
        if (!EmptyUtil.isEmpty(propertySources)) {
            for (PropertySource<?> propertySource : propertySources) {
                environment.getPropertySources().addLast(propertySource);
            }
        }
    }

    private String clearPath(String path) {
        if (path.contains(String.valueOf('\\'))) {
            path = path.replaceAll("\\\\", "/");
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        return path;
    }

    private void setSystemAndLoggerProFilePath(ConfigurableEnvironment environment, String[] configDir, String logbackPath) {
        Properties properties = new Properties();
        properties.setProperty("logback.path", logbackPath);
        properties.setProperty("system.config.file.base.dir", StringUtils.arrayToCommaDelimitedString((Object[])configDir));
        environment.getPropertySources().addAfter("app.yml", (PropertySource)new PropertiesPropertySource("sys_and_log", properties));
    }

    private void setSpringConfigLocationProperty(ConfigurableEnvironment environment, String configLocation) {
        String[] configPaths = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)configLocation));
        StringBuilder locationBuffer = new StringBuilder();
        for (int i = 0; i < configPaths.length; ++i) {
            String configPath = configPaths[i];
            configPath = this.clearPath(configPath);
            if (i > 0) {
                locationBuffer.append(",");
            }
            locationBuffer.append(configPath).append("config").append('/');
        }
        Properties properties = new Properties();
        properties.setProperty("spring.config.location", locationBuffer.toString());
        environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("new_config_location", properties));
    }

    private void loadAppCenterConfigFile(ConfigurableEnvironment environment) {
        Resource resource = this.getResource("classpath:/app.yml");
        try {
            boolean exists;
            boolean bl = exists = resource != null && resource.exists();
            if (!exists) {
                throw new IllegalArgumentException("app.yml does not exists under classpath");
            }
            PropertySource<?> propertySource = PropertiesLoadHelper.INSTANCE.load("app.yml", resource).get(0);
            MutablePropertySources mutablePropertySources = environment.getPropertySources();
            mutablePropertySources.addAfter("systemEnvironment", propertySource);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("app.yml load error", e);
        }
    }
}

