/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.environment;

import com.xjda.framework.agreement.central.scope.RefreshAbleScope;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

public class ConfigurationPropertiesBeanCollector
implements BeanPostProcessor,
ApplicationContextAware {
    private Set<String> beanNames = new HashSet<String>();
    private ConfigurableListableBeanFactory beanFactory;
    private String refreshAbleScope;
    private boolean refreshAbleScopeInitialized;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties configurationProperties;
        if (!this.isRefreshAbleBean(beanName) && (configurationProperties = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class)) != null) {
            this.beanNames.add(beanName);
        }
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigurableListableBeanFactory listable;
        String[] names;
        if (applicationContext.getAutowireCapableBeanFactory() instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        }
        if (applicationContext.getParent() != null && applicationContext.getParent().getAutowireCapableBeanFactory() instanceof ConfigurableListableBeanFactory && (names = (listable = (ConfigurableListableBeanFactory)applicationContext.getParent().getAutowireCapableBeanFactory()).getBeanNamesForType(ConfigurationPropertiesBeanCollector.class)).length == 1) {
            ConfigurationPropertiesBeanCollector parent = (ConfigurationPropertiesBeanCollector)listable.getBean(names[0]);
            this.beanNames.addAll(parent.beanNames);
        }
    }

    private boolean isRefreshAbleBean(String beanName) {
        if (this.refreshAbleScope == null && !this.refreshAbleScopeInitialized) {
            String[] registeredScopeNames;
            this.refreshAbleScopeInitialized = true;
            for (String registeredScopeName : registeredScopeNames = this.beanFactory.getRegisteredScopeNames()) {
                if (!(this.beanFactory.getRegisteredScope(registeredScopeName) instanceof RefreshAbleScope)) continue;
                this.refreshAbleScope = registeredScopeName;
                break;
            }
        }
        if (beanName != null && this.refreshAbleScope != null) {
            return this.beanFactory.containsBeanDefinition(beanName) && this.refreshAbleScope.equals(this.beanFactory.getBeanDefinition(beanName).getScope());
        }
        return false;
    }

    public Set<String> getBeanNames() {
        return new HashSet<String>(this.beanNames);
    }
}

