/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.environment;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PropertiesLoadHelper {
    private PropertySourceLoader propertySourceLoader = new PropertiesPropertySourceLoader();
    private PropertySourceLoader yamlSourceLoader = new YamlPropertySourceLoader();
    public static PropertiesLoadHelper INSTANCE = new PropertiesLoadHelper();

    private PropertiesLoadHelper() {
    }

    public List<PropertySource<?>> load(String fileName, Resource resource) throws IOException {
        String expression = fileName.substring(fileName.lastIndexOf("."));
        List<Object> propertySources = ".properties".equalsIgnoreCase(expression) ? this.propertySourceLoader.load(fileName, resource) : this.yamlSourceLoader.load(fileName, resource);
        if (propertySources == null || propertySources.isEmpty()) {
            PropertiesPropertySource propertiesPropertySource = new PropertiesPropertySource(fileName, new Properties());
            propertySources = Collections.singletonList(propertiesPropertySource);
        }
        return propertySources;
    }

    public List<PropertySource<?>> loadProperties(File file) throws IOException {
        FileSystemResource resource = new FileSystemResource(file);
        if (!resource.exists()) {
            throw new IllegalArgumentException(String.format("fetch config file [%s] error.", resource.getFilename()));
        }
        String fileFullName = file.getName();
        return this.load(fileFullName, (Resource)resource);
    }
}

