/*
 * Decompiled with CFR 0.152.
 */
package com.xjda.framework.agreement.central.scope;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

public class RefreshAbleScope
implements Scope,
BeanFactoryPostProcessor,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshAbleScope.class);
    private String name = "RefreshAbleScope";
    private MyScopeCache scopeCache = new MyScopeCache();
    private ConcurrentHashMap<String, ReadWriteLock> locks = new ConcurrentHashMap();

    public Object get(String name, ObjectFactory<?> objectFactory) {
        BeanWrapper wrapper = this.scopeCache.put(name, new BeanWrapper(name, objectFactory));
        this.locks.putIfAbsent(name, new ReentrantReadWriteLock());
        try {
            return wrapper.getBean();
        }
        catch (RuntimeException var5) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u83b7\u53d6bean [{}]\u5f02\u5e38:{}", (Object)name, (Object)var5.getMessage());
            } else {
                LOGGER.error("\u83b7\u53d6bean [{}]\u5f02\u5e38", (Object)name, (Object)var5);
            }
            throw var5;
        }
    }

    public Object remove(String name) {
        return this.scopeCache.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Collection<BeanWrapper> wrappers = this.scopeCache.clear();
        try {
            for (BeanWrapper w : wrappers) {
                Lock lock = this.locks.get(w.getName()).writeLock();
                lock.lock();
                try {
                    w.destroy();
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (Exception var9) {
            throw new Exception("destroy error ..");
        }
    }

    public void registerDestructionCallback(String s, Runnable runnable) {
        LOGGER.debug("=== registerDestructionCallback ===");
    }

    public Object resolveContextualObject(String s) {
        LOGGER.debug("=== resolveContextualObject ===" + s);
        return null;
    }

    public String getConversationId() {
        LOGGER.debug("=== getConversationId ===");
        return this.name;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        configurableListableBeanFactory.registerScope(this.name, (Scope)this);
    }

    private static class BeanWrapper {
        private final String name;
        private ObjectFactory<?> objectFactory;
        private Object bean;

        BeanWrapper(String name, ObjectFactory<?> objectFactory) {
            this.name = name;
            this.objectFactory = objectFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getBean() {
            if (this.bean == null) {
                String string = this.name;
                synchronized (string) {
                    if (this.bean == null) {
                        this.bean = this.objectFactory.getObject();
                    }
                }
            }
            return this.bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            if (this.bean != null) {
                String string = this.name;
                synchronized (string) {
                    this.bean = null;
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                BeanWrapper that = (BeanWrapper)o;
                return Objects.equals(this.name, that.name);
            }
            return false;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        String getName() {
            return this.name;
        }
    }

    private static class MyScopeCache {
        private ConcurrentHashMap<String, BeanWrapper> cache = new ConcurrentHashMap();

        private MyScopeCache() {
        }

        BeanWrapper remove(String name) {
            return this.cache.remove(name);
        }

        Collection<BeanWrapper> clear() {
            Collection<BeanWrapper> values = this.cache.values();
            LinkedHashSet<BeanWrapper> wrappers = new LinkedHashSet<BeanWrapper>(values);
            this.cache.clear();
            return wrappers;
        }

        BeanWrapper put(String name, BeanWrapper beanWrapper) {
            BeanWrapper result = this.cache.putIfAbsent(name, beanWrapper);
            return result == null ? beanWrapper : result;
        }
    }
}

