/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm;

import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.alg.AlgId;
import com.xdja.hsm.api.bean.EccCipher;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.hsm.api.bean.EccSignature;

public class HsmUtil {
    private static Long session;
    private static final int HSM_REP_SUCCESS = 0;
    private static final int HSM_FILE_NOT_EXIST = 0x1000012;
    private static final int HSM_FILE_EXIST = 0x100001A;
    private static final SdfApi hsmApi;
    private static String SDK_CONF_PATH;
    private static final String SIGN_USER_ID = "1234567812345678";
    private static final String SM4_CBC_INIT_IV = "1234567812345678";
    public static final int SM4_ENCRYPT = 1;
    public static final int SM4_DECRYPT = 2;

    public static synchronized Long createSession() {
        long[] dev = new long[]{0L};
        long[] ses = new long[]{0L};
        int ret = hsmApi.openDevice(dev);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u6253\u5f00\u8bbe\u5907\u5931\u8d25 ret\uff1a" + ret);
        }
        ret = hsmApi.initialize(dev[0], SDK_CONF_PATH.getBytes());
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25 ret\uff1a" + ret);
        }
        ret = hsmApi.openSession(dev[0], ses);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u521b\u5efa\u4f1a\u8bdd\u5931\u8d25 ret\uff1a" + ret);
        }
        session = ses[0];
        return session;
    }

    private static long getSession() {
        int ran;
        if (null != session && (ran = hsmApi.generateRandom(session.longValue(), 1, new byte[1])) == 0) {
            return session;
        }
        return HsmUtil.createSession();
    }

    public static byte[] genRandom(int length) {
        byte[] data = new byte[length];
        int ret = hsmApi.generateRandom(HsmUtil.getSession(), length, data);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u751f\u6210\u968f\u673a\u6570\u5931\u8d25,ret\uff1a" + ret);
        }
        return data;
    }

    public static byte[] sm2Encrypt(int index, byte[] data) {
        EccPublicKey eccPublicKey = new EccPublicKey();
        int ret = hsmApi.exportEncPublicKeyEcc(HsmUtil.getSession(), index, eccPublicKey);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u5bfc\u51fa\u52a0\u5bc6\u516c\u94a5\u5931\u8d25,ret\uff1a" + ret);
        }
        EccCipher eccCipher = new EccCipher();
        ret = hsmApi.externalEncryptEcc(HsmUtil.getSession(), AlgId.SGD_SM2, eccPublicKey, data, data.length, eccCipher);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u516c\u94a5\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
        }
        return HsmUtil.eccCipherEncode(eccCipher);
    }

    public static byte[] sm2Decrypt(int index, byte[] cipherText) {
        EccCipher eccCipher = HsmUtil.eccCipherDecode(cipherText);
        byte[] data = new byte[cipherText.length];
        int[] lg = new int[1];
        int ret = hsmApi.internalDecryptEcc(HsmUtil.getSession(), index, AlgId.SGD_SM2, eccCipher, data, lg);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM2\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25,ret\uff1a" + ret);
        }
        byte[] realData = new byte[lg[0]];
        System.arraycopy(data, 0, realData, 0, realData.length);
        return realData;
    }

    public static boolean createFile(byte[] fileName, int fileSize) {
        int ret = hsmApi.createFile(HsmUtil.getSession(), fileName, fileName.length, fileSize);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25,ret\uff1a" + ret);
        }
        return true;
    }

    public static boolean writeFile(byte[] fileName, byte[] fileContent) {
        int ret = hsmApi.writeFile(HsmUtil.getSession(), fileName, fileName.length, 0, fileContent.length, fileContent);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u5199\u6587\u4ef6\u5931\u8d25,ret\uff1a" + ret);
        }
        return true;
    }

    public static EccSignature sm2Sign(int signIndex, byte[] data) {
        EccSignature eccSignature = new EccSignature();
        byte[] hash = HsmUtil.preSm3(signIndex, null, data);
        int ret = hsmApi.internalSignEcc(HsmUtil.getSession(), signIndex, hash, hash.length, eccSignature);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + ret);
        }
        return eccSignature;
    }

    public static boolean sm2SignVerity(int signIndex, EccSignature eccSignature, byte[] data) {
        byte[] hash = HsmUtil.preSm3(signIndex, null, data);
        int ret = hsmApi.internalVerifyEcc(HsmUtil.getSession(), signIndex, hash, hash.length, eccSignature);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
        }
        return true;
    }

    public static boolean sm2SignVerityByExternalPk(EccPublicKey eccPublicKey, byte[] data, EccSignature eccSignature) {
        byte[] hash = HsmUtil.preSm3(null, eccPublicKey, data);
        int ret = hsmApi.externalVerifyEcc(HsmUtil.getSession(), AlgId.SGD_SM2, eccPublicKey, hash, hash.length, eccSignature);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM2\u5916\u90e8\u516c\u94a5\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
        }
        return true;
    }

    public static byte[] sm4Encrypt(byte[] key, byte[] data) {
        byte[] totalCipher;
        long handle = HsmUtil.getKeyHandle(key);
        byte[] input = HsmUtil.padding(data, 1);
        long inLg = input.length;
        byte[] iv = "1234567812345678".getBytes();
        if (input.length > 4096) {
            int ret;
            int[] lg;
            byte[] cipher;
            byte[] inData;
            totalCipher = new byte[input.length];
            int count = (int)(inLg / 4096L);
            for (int i = 0; i < count; ++i) {
                inData = new byte[4096];
                System.arraycopy(input, i * 4096, inData, 0, 4096);
                cipher = new byte[4096];
                lg = new int[]{4096};
                ret = hsmApi.encrypt(HsmUtil.getSession(), handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, cipher, lg);
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                System.arraycopy(cipher, 0, totalCipher, i * 4096, 4096);
            }
            int rem = input.length - count * 4096;
            if (input.length - count * 4096 > 0) {
                inData = new byte[rem];
                System.arraycopy(input, input.length - rem, inData, 0, rem);
                cipher = new byte[rem];
                lg = new int[]{rem};
                ret = hsmApi.encrypt(HsmUtil.getSession(), handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, cipher, lg);
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                System.arraycopy(cipher, 0, totalCipher, count * 4096, rem);
            }
        } else {
            totalCipher = new byte[input.length];
            int ret = hsmApi.encrypt(HsmUtil.getSession(), handle, AlgId.SGD_SM4_CBC, iv, input, input.length, totalCipher, new int[]{input.length});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
            }
        }
        HsmUtil.releaseHandle(handle);
        return totalCipher;
    }

    public static byte[] sm4Decrypt(byte[] key, byte[] cipher) {
        byte[] totalData;
        long handle = HsmUtil.getKeyHandle(key);
        byte[] iv = "1234567812345678".getBytes();
        if (cipher.length > 4096) {
            int ret;
            int[] lg;
            byte[] outData;
            byte[] inData;
            totalData = new byte[cipher.length];
            int count = cipher.length / 4096;
            for (int i = 0; i < count; ++i) {
                inData = new byte[4096];
                System.arraycopy(cipher, i * 4096, inData, 0, 4096);
                outData = new byte[4096];
                lg = new int[]{4096};
                ret = hsmApi.decrypt(HsmUtil.getSession(), handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, outData, lg);
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                System.arraycopy(outData, 0, totalData, i * 4096, 4096);
            }
            int rem = cipher.length - count * 4096;
            if (cipher.length - count * 4096 > 0) {
                inData = new byte[rem];
                System.arraycopy(cipher, cipher.length - rem, inData, 0, rem);
                outData = new byte[rem];
                lg = new int[]{rem};
                ret = hsmApi.decrypt(HsmUtil.getSession(), handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, outData, lg);
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                System.arraycopy(outData, 0, totalData, count * 4096, rem);
            }
        } else {
            totalData = new byte[cipher.length];
            int ret = hsmApi.decrypt(HsmUtil.getSession(), handle, AlgId.SGD_SM4_CBC, iv, cipher, cipher.length, totalData, new int[]{totalData.length});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
            }
        }
        byte[] outData = HsmUtil.padding(totalData, 2);
        HsmUtil.releaseHandle(handle);
        return outData;
    }

    public static byte[] sm3(byte[] data) {
        int ret = hsmApi.hashInit(HsmUtil.getSession(), AlgId.SGD_SM3, null, null, 0);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM3\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        ret = hsmApi.hashUpdate(HsmUtil.getSession(), data, data.length);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM3\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        byte[] hash = new byte[32];
        ret = hsmApi.hashFinal(HsmUtil.getSession(), hash, new int[]{32});
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM3\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        return hash;
    }

    public static byte[] hmacSm3(byte[] key, byte[] data) {
        long handle = HsmUtil.getKeyHandle(key);
        int ret = hsmApi.hmacInit(HsmUtil.getSession(), handle, AlgId.SGD_SM3);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        ret = hsmApi.hmacUpdate(HsmUtil.getSession(), data, data.length);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        byte[] hmacSM3 = new byte[32];
        ret = hsmApi.hmacFinal(HsmUtil.getSession(), hmacSM3, new int[]{32});
        if (ret != 0) {
            throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        HsmUtil.releaseHandle(handle);
        return hmacSM3;
    }

    private static long getKeyHandle(byte[] key) {
        long[] handles = new long[1];
        int ret = hsmApi.importKey(HsmUtil.getSession(), key, key.length, handles);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u5bfc\u5165\u5bc6\u94a5\u5931\u8d25,ret\uff1a" + ret);
        }
        return handles[0];
    }

    private static void releaseHandle(long handle) {
        int ret = hsmApi.destroyKey(HsmUtil.getSession(), handle);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u91ca\u653e\u4f1a\u8bdd\u53e5\u67c4\u5931\u8d25,ret\uff1a" + ret);
        }
    }

    public static byte[] readFile(byte[] fileName, int length) {
        int[] lg = new int[]{length};
        byte[] fileContent = new byte[length];
        int ret = hsmApi.readFile(HsmUtil.getSession(), fileName, fileName.length, 0, lg, fileContent);
        if (ret != 0) {
            if (0x1000012 == ret) {
                return null;
            }
            throw new CryptOperatorException(ret, "\u8bfb\u6587\u4ef6\u5931\u8d25,ret\uff1a" + ret);
        }
        return fileContent;
    }

    private static byte[] preSm3(Integer signIndex, EccPublicKey eccPublicKey, byte[] data) {
        int ret;
        if (null == eccPublicKey) {
            eccPublicKey = new EccPublicKey();
            ret = hsmApi.exportSignPublicKeyEcc(HsmUtil.getSession(), signIndex.intValue(), eccPublicKey);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u7b7e\u540d\u516c\u94a5\u5bfc\u51fa\u5931\u8d25,ret\uff1a" + ret);
            }
        }
        if ((ret = hsmApi.hashInit(HsmUtil.getSession(), AlgId.SGD_SM3, eccPublicKey, "1234567812345678".getBytes(), "1234567812345678".getBytes().length)) != 0) {
            throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        ret = hsmApi.hashUpdate(HsmUtil.getSession(), data, data.length);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        byte[] hash = new byte[32];
        ret = hsmApi.hashFinal(HsmUtil.getSession(), hash, new int[]{32});
        if (ret != 0) {
            throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
        }
        return hash;
    }

    public static void setSdkConfPath(String path) {
        SDK_CONF_PATH = path;
    }

    private static byte[] padding(byte[] input, int mode) {
        byte[] ret;
        if (input == null) {
            return null;
        }
        if (mode == 1) {
            int p = 16 - input.length % 16;
            ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            for (int i = 0; i < p; ++i) {
                ret[input.length + i] = (byte)p;
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }

    private static byte[] eccCipherEncode(EccCipher eccCipher) {
        byte[] x = new byte[32];
        System.arraycopy(eccCipher.getX(), 32, x, 0, 32);
        byte[] y = new byte[32];
        System.arraycopy(eccCipher.getY(), 32, y, 0, 32);
        byte[] m = eccCipher.getM();
        byte[] c = eccCipher.getC();
        byte[] l = HsmUtil.intToBytes(eccCipher.getL());
        byte[] encode = new byte[x.length + y.length + m.length + c.length + l.length];
        System.arraycopy(x, 0, encode, 0, x.length);
        System.arraycopy(y, 0, encode, x.length, y.length);
        System.arraycopy(m, 0, encode, x.length + y.length, m.length);
        System.arraycopy(l, 0, encode, x.length + y.length + m.length, l.length);
        System.arraycopy(c, 0, encode, x.length + y.length + m.length + l.length, c.length);
        System.out.println("eccCipherEncode encode" + encode.length);
        return encode;
    }

    private static EccCipher eccCipherDecode(byte[] encode) {
        System.out.println("eccCipherDecode encode" + encode.length);
        EccCipher eccCipher = new EccCipher();
        byte[] x = eccCipher.getX();
        System.arraycopy(encode, 0, x, 32, 32);
        byte[] y = eccCipher.getY();
        System.arraycopy(encode, 32, y, 32, 32);
        byte[] m = eccCipher.getM();
        System.arraycopy(encode, 64, m, 0, 32);
        byte[] l = new byte[4];
        System.arraycopy(encode, 96, l, 0, 1);
        int cl = HsmUtil.bytesToInt(l);
        byte[] c = new byte[cl];
        System.arraycopy(encode, 97, c, 0, cl);
        eccCipher.setX(x);
        eccCipher.setY(y);
        eccCipher.setM(m);
        eccCipher.setL(cl);
        eccCipher.setC(c);
        return eccCipher;
    }

    private static byte[] intToBytes(int a) {
        byte[] ans = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ans[i] = (byte)(a >> i * 8);
        }
        return new byte[]{ans[0]};
    }

    public static int bytesToInt(byte[] a) {
        int ans = 0;
        for (int i = 0; i < 4; ++i) {
            ans <<= 8;
            ans |= a[3 - i] & 0xFF;
        }
        return ans;
    }

    static {
        hsmApi = new SdfApi();
    }
}

