/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.usecase.keymanage;

import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyInfo;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.model.KeyManageService;
import com.xdja.cryptoappkit.usecase.keymanage.DefaultKeyInfoRepository;
import com.xdja.cryptoappkit.usecase.keymanage.KeyInfoRepository;
import java.util.List;

public class KeyManageUseCase {
    KeyManageService keyManageService;
    KeyInfoRepository keyInfoRepository = new DefaultKeyInfoRepository();

    public KeyManageUseCase(CryptoAppKitProperties cryptoAppKitProperties) {
        this.keyManageService = new KeyManageService(cryptoAppKitProperties);
    }

    public boolean initKey() {
        try {
            List<KeyInfo> backups = this.keyManageService.initKey();
            this.keyInfoRepository.backupKey(backups);
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
        return true;
    }

    public boolean getKeyInitResult() {
        return this.keyManageService.checkKeyInit();
    }

    public void setKeyInfoRepository(KeyInfoRepository keyInfoRepository) {
        this.keyInfoRepository = keyInfoRepository;
    }
}

