/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm;

import com.xdja.cryptoappkit.device.hsm.HsmUtil;
import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.bean.KeyInfo;
import com.xdja.cryptoappkit.domain.operator.keymanage.KeyManageOperator;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;

public class HsmKeyManageOperator
implements KeyManageOperator {
    private static final HsmKeyManageOperator hsmKeyManageOperator = new HsmKeyManageOperator();
    static CryptoAppKitProperties.Hsm hsmProperties = CryptoAppKitProperties.getInstance().getHsm();
    private static final String KEY_STORE_FILE_NAME = hsmProperties.getAppName() + "_keyStoreFile_" + hsmProperties.getExchangeKeyIndex();
    KeyCache keyCache = KeyCache.getInstance();

    public static HsmKeyManageOperator getInstance() {
        HsmUtil.setSdkConfPath(hsmProperties.getYunHsmSdkConfPath());
        return hsmKeyManageOperator;
    }

    @Override
    public List<KeyInfo> initKey() {
        byte[] sm4Key = HsmUtil.genRandom(16);
        byte[] hmacSm3Key = HsmUtil.genRandom(32);
        byte[] sm4KeyAndHmacSm3Key = ArrayUtils.addAll((byte[])sm4Key, (byte[])hmacSm3Key);
        byte[] sm2Key = HsmUtil.sm2Encrypt(hsmProperties.getExchangeKeyIndex(), sm4KeyAndHmacSm3Key);
        byte[] sm3 = HsmUtil.sm3(sm4KeyAndHmacSm3Key);
        HsmUtil.createFile(KEY_STORE_FILE_NAME.getBytes(), sm2Key.length + sm3.length);
        byte[] fileContext = ArrayUtils.addAll((byte[])sm2Key, (byte[])sm3);
        HsmUtil.writeFile(KEY_STORE_FILE_NAME.getBytes(), ArrayUtils.addAll((byte[])sm2Key, (byte[])sm3));
        this.keyCache.setKey4SM4(Base64.getEncoder().encodeToString(sm4Key));
        this.keyCache.setKey4HmacSM3(Base64.getEncoder().encodeToString(hmacSm3Key));
        ArrayList<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setDeviceId(UUID.randomUUID().toString());
        keyInfo.setHsmType(1);
        keyInfo.setEncryptedKeys(Base64.getEncoder().encodeToString(fileContext));
        keyInfo.setKeysHashBySM3(Base64.getEncoder().encodeToString(SoftOperatorUtil.sm3(fileContext)));
        keyInfoList.add(keyInfo);
        return keyInfoList;
    }

    @Override
    public byte[] readFile(int length) {
        return HsmUtil.readFile(KEY_STORE_FILE_NAME.getBytes(), length);
    }

    @Override
    public byte[] sm2Decrypt(byte[] ciphertext) {
        return HsmUtil.sm2Decrypt(hsmProperties.getExchangeKeyIndex(), ciphertext);
    }
}

