/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm;

import com.xdja.cryptoappkit.device.hsm.HsmUtil;
import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.sign.SignOperator;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.hsm.api.bean.EccSignature;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.BigIntegers;

public class HsmSignOperator
implements SignOperator {
    CryptoAppKitProperties.Hsm hsmProperties = CryptoAppKitProperties.getInstance().getHsm();
    private static final HsmSignOperator hsmSignOperator = new HsmSignOperator();

    public static HsmSignOperator getInstance() {
        return hsmSignOperator;
    }

    @Override
    public byte[] sm2sign(byte[] data) {
        try {
            EccSignature eccSignature = HsmUtil.sm2Sign(this.hsmProperties.getSignKeyIndex(), data);
            byte[] r = new byte[32];
            byte[] s = new byte[32];
            System.arraycopy(eccSignature.getR(), 32, r, 0, 32);
            System.arraycopy(eccSignature.getS(), 32, s, 0, 32);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])r)));
            v.add((ASN1Encodable)new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])s)));
            return new DERSequence(v).getEncoded("DER");
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u7b7e\u540d\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public boolean sm2SignVerity(byte[] orgData, byte[] signData) {
        try {
            EccSignature eccSignature = this.buildEccSignatureBySign(signData, true);
            HsmUtil.sm2SignVerity(this.hsmProperties.getSignKeyIndex(), eccSignature, orgData);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u9a8c\u7b7e\u5931\u8d25\uff1a" + e.getMessage());
        }
        return true;
    }

    @Override
    public boolean sm2SignVerity(String signCert, byte[] orgData, byte[] signData, boolean isUseAsn1Encode) {
        try {
            EccSignature eccSignature = this.buildEccSignatureBySign(signData, isUseAsn1Encode);
            EccPublicKey eccPublicKey = new EccPublicKey();
            eccPublicKey.setBits(256);
            BCECPublicKey bcecPublicKey = (BCECPublicKey)SoftOperatorUtil.getPublicKeyByCert(signCert);
            byte[] x = eccPublicKey.getX();
            byte[] y = eccPublicKey.getY();
            byte[] xx = SoftOperatorUtil.changeByteArrayLength(bcecPublicKey.getQ().getXCoord().getEncoded(), 32);
            byte[] yy = SoftOperatorUtil.changeByteArrayLength(bcecPublicKey.getQ().getYCoord().getEncoded(), 32);
            System.arraycopy(xx, 0, x, 32, 32);
            System.arraycopy(yy, 0, y, 32, 32);
            eccPublicKey.setX(x);
            eccPublicKey.setY(y);
            return HsmUtil.sm2SignVerityByExternalPk(eccPublicKey, orgData, eccSignature);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u9a8c\u7b7e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private EccSignature buildEccSignatureBySign(byte[] signData, boolean isUseAsn1Encode) {
        EccSignature eccSignature = new EccSignature();
        byte[] rr = eccSignature.getR();
        byte[] ss = eccSignature.getS();
        if (isUseAsn1Encode) {
            BigInteger[] integers;
            try {
                integers = SoftOperatorUtil.derSignatureDecode(signData);
            }
            catch (IOException e) {
                throw new CryptOperatorException("\u7b7e\u540d\u503c\u89e3\u7801\u5931\u8d25");
            }
            assert (integers != null);
            BigInteger r = integers[0];
            BigInteger s = integers[1];
            System.arraycopy(r.toByteArray(), r.toByteArray().length - 32, rr, 32, 32);
            System.arraycopy(s.toByteArray(), s.toByteArray().length - 32, ss, 32, 32);
        } else {
            System.arraycopy(signData, 0, rr, 32, 32);
            System.arraycopy(signData, 32, ss, 32, 32);
        }
        eccSignature.setR(rr);
        eccSignature.setS(ss);
        return eccSignature;
    }
}

