/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.cert.CertOperator;
import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang3.StringUtils;

public class SoftCertOperator
implements CertOperator {
    private static final int CERT_VALIDITY_TYPE_CRL = 1;
    private static final int CERT_VALIDITY_TYPE_OCSP = 2;
    CryptoAppKitProperties.CertInfo certInfo = CryptoAppKitProperties.getInstance().getCertInfo();
    private static final SoftCertOperator softCryptOperator = new SoftCertOperator();

    public static SoftCertOperator getInstance() {
        return softCryptOperator;
    }

    @Override
    public boolean certVerify(String cert) {
        if (StringUtils.isBlank((CharSequence)this.certInfo.getRootCertPath())) {
            throw new CryptOperatorException("\u6839\u8bc1\u4e66\u8def\u5f84\u6ca1\u6709\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)this.certInfo.getCertChainFilePath())) {
            throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u6587\u4ef6\u8def\u5f84\u6ca1\u6709\u914d\u7f6e");
        }
        SoftOperatorUtil.checkCertChain(cert, this.certInfo.getRootCertPath(), this.certInfo.getCertChainFilePath());
        if (1 == this.certInfo.getCertValidityType()) {
            this.checkCertByLdap(cert, this.certInfo.getCrlDn(), this.certInfo.getLdapIp(), this.certInfo.getLdapPort(), this.certInfo.getCrlFileCachePath());
        } else if (2 != this.certInfo.getCertValidityType()) {
            throw new CryptOperatorException("\u8bc1\u4e66\u7684\u64a4\u9500\u72b6\u6001\u9009\u62e9crl\u548cocsp\u4e2d\u7684\u4e00\u79cd\u68c0\u9a8c\u65b9\u5f0f");
        }
        return true;
    }

    private void checkCertByLdap(String cert, String crlDn, String ldapIp, String ldapPort, String crlFilePath) {
        X509Certificate x509Certificate = SoftOperatorUtil.getX509CertificateByCert(cert);
        String certSerialNumber = x509Certificate.getSerialNumber().toString(16).toLowerCase();
        List<X509CRL> crlList = SoftOperatorUtil.getCrlList(crlFilePath);
        if (null == crlList) {
            crlList = this.getCrlList(crlDn, ldapIp, ldapPort, crlFilePath);
        }
        for (X509CRL crl : crlList) {
            Set<? extends X509CRLEntry> revokedCertificates = crl.getRevokedCertificates();
            if (null == revokedCertificates) continue;
            for (X509CRLEntry x509CRLEntry : revokedCertificates) {
                if (!certSerialNumber.equals(x509CRLEntry.getSerialNumber().toString(16).toLowerCase())) continue;
                throw new CryptOperatorException("\u8be5\u8bc1\u4e66\u5df2\u64a4\u9500\u4e0d\u53ef\u7528");
            }
        }
    }

    private List<X509CRL> getCrlList(String crlDn, String ldapIp, String ldapPort, String crlFilePath) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ldapIp + ":" + ldapPort + "/");
        InitialDirContext ctx = null;
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        try {
            String[] crlDnArry;
            ctx = new InitialDirContext(env);
            for (String crlD : crlDnArry = crlDn.split(":")) {
                if (null == crlD || crlD.length() <= 0) continue;
                byte[] bsCrl = SoftOperatorUtil.lookupCrl(ctx, crlDn, this.certInfo.getCrlAttrName());
                new Thread(() -> SoftOperatorUtil.saveCrlFile(bsCrl, crlFilePath)).start();
                ByteArrayInputStream bais = new ByteArrayInputStream(bsCrl);
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                CRL crl = cf.generateCRL(bais);
                if (null == crl) continue;
                crlList.add((X509CRL)crl);
            }
            ArrayList<X509CRL> arrayList = crlList;
            return arrayList;
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u83b7\u53d6CRL\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ctx) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    throw new CryptOperatorException("ldap\u6d41\u5173\u95ed\u5931\u8d25");
                }
            }
        }
    }
}

