/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.crypt.CryptOperator;

public class SoftCryptOperator
implements CryptOperator {
    private static final SoftCryptOperator softCryptOperator = new SoftCryptOperator();

    public static SoftCryptOperator getInstance() {
        return softCryptOperator;
    }

    @Override
    public byte[] sm4Encrypt(byte[] key, byte[] data) {
        return SoftOperatorUtil.sm4Encrypt(key, data);
    }

    @Override
    public byte[] sm4Decrypt(byte[] key, byte[] cipherText) {
        try {
            return SoftOperatorUtil.sm4Decrypt(key, cipherText);
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    @Override
    public byte[] hmacSM3(byte[] key, byte[] data) {
        return SoftOperatorUtil.hmacWithSm3(key, data);
    }

    @Override
    public byte[] sm3(byte[] data) {
        return SoftOperatorUtil.sm3(data);
    }
}

