/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Store;

public class SoftOperatorUtil {
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    private static final String ALGORITHM = "SM3WithSM2";
    private static final String INIT_IV = "1234567812345678";
    public static final String ALGORITHM_SM4 = "SM4";
    public static final String ALGORITHM_NAME_CBC_PKCS7PADDING = "SM4/CBC/PKCS7Padding";

    public static byte[] sm4Encrypt(byte[] key, byte[] data) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_SM4);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PKCS7PADDING, "BC");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(INIT_IV.getBytes());
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM4\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static byte[] sm4Decrypt(byte[] key, byte[] data) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_SM4);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PKCS7PADDING, "BC");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(INIT_IV.getBytes());
            cipher.init(2, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM4\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static byte[] hmacWithSm3(byte[] key, byte[] data) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(data, 0, data.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static byte[] sm3(byte[] data) {
        SM3Digest digest = new SM3Digest();
        digest.update(data, 0, data.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static boolean verifySign(PublicKey publicKey, byte[] dataBytes, byte[] signature) {
        try {
            Signature vinstance = Signature.getInstance(ALGORITHM, "BC");
            vinstance.initVerify(publicKey);
            vinstance.update(dataBytes);
            return vinstance.verify(signature);
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public static PublicKey getPublicKeyByCert(String cert) {
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = SoftOperatorUtil.getCertFromStr(cert);
            return x509Certificate.getPublicKey();
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u4ece\u8bc1\u4e66\u4e2d\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
        }
    }

    public static X509Certificate getX509CertificateByCert(String cert) {
        CertificateFactory certificatefactory = null;
        try {
            cert = cert.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
            cert = cert.replace("\r", "").replace("\n", "");
            cert = cert.replace("\\r", "").replace("\\n", "");
            certificatefactory = CertificateFactory.getInstance("X.509", "BC");
            byte[] pkByte = Base64.getDecoder().decode(cert);
            X509Certificate x509Certificate = (X509Certificate)certificatefactory.generateCertificate(new ByteArrayInputStream(pkByte));
            return x509Certificate;
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new CryptOperatorException("\u89e3\u6790\u8bc1\u4e66\u5931\u8d25");
        }
    }

    public static byte[] changeByteArrayLength(byte[] bb, int len) {
        if (bb.length == len) {
            return bb;
        }
        return bb.length < len ? SoftOperatorUtil.fillByteArrayWithZeroInHead(bb, len) : SoftOperatorUtil.filterByteArrayZeroInHead(bb, len);
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss, int len) {
        if (ss.length == len) {
            return ss;
        }
        byte[] bs = new byte[len];
        java.util.Arrays.fill(bs, (byte)0);
        System.arraycopy(ss, 0, bs, len - ss.length, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, ss.length - len, bs, 0, len);
        return bs;
    }

    public static X509Certificate readCertificateFromCer(String path) throws Exception {
        InputStream systemResourceAsStream = SoftOperatorUtil.readInputStreamFromPath(path);
        return SoftOperatorUtil.readCertificateFromCerInputStream(systemResourceAsStream);
    }

    public static X509Certificate readCertificateFromCerInputStream(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)factory.generateCertificate(inputStream);
    }

    public static InputStream readInputStreamFromPath(String filename) throws FileNotFoundException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(filename);
        if (inputStream == null) {
            inputStream = new FileInputStream(filename);
        }
        return inputStream;
    }

    public static byte[] lookupCrl(DirContext ctx, String crlDn, String crlAttrName) throws Exception {
        DirContext dirContext = (DirContext)ctx.lookup(crlDn);
        Attributes attributes = dirContext.getAttributes("");
        return (byte[])attributes.get(crlAttrName).get();
    }

    public static void saveCrlFile(byte[] crlByte, String filePath) {
        try (FileOutputStream output = new FileOutputStream(filePath + "crl.crl");
             BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);){
            bufferedOutput.write(crlByte);
            bufferedOutput.flush();
            output.flush();
        }
        catch (Exception e) {
            throw new CryptOperatorException("crl\u6587\u4ef6\u5199\u5165\u5931\u8d25");
        }
    }

    public static List<X509CRL> getCrlList(String crlFilePath) {
        try {
            ArrayList<X509CRL> list = new ArrayList<X509CRL>();
            FileInputStream fileInputStream = new FileInputStream(crlFilePath + "crl.crl");
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509CRL crl = (X509CRL)cf.generateCRL(fileInputStream);
            if (crl.getNextUpdate().compareTo(new Date()) > 0) {
                list.add(crl);
                return list;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            FileInputStream fileInputStream = new FileInputStream("D:\\crl.crl");
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509CRL crl = (X509CRL)cf.generateCRL(fileInputStream);
            System.out.println(crl);
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u4ece\u672c\u5730crl\u6587\u4ef6\u4e2d\u83b7\u53d6crl\u5217\u8868\u5931\u8d25");
        }
    }

    public static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, OperatorException, CertificateEncodingException {
        CertificateID id = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
        OCSPReqBuilder generator = new OCSPReqBuilder();
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Vector<ASN1ObjectIdentifier> objectIdentifiers = new Vector<ASN1ObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        objectIdentifiers.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(nonce.toByteArray())));
        generator.setRequestExtensions(Extensions.getInstance((Object)new X509Extensions(objectIdentifiers, values)));
        generator.addRequest(id);
        return generator.build();
    }

    public static OCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, OCSPException, IOException, OperatorException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            return null;
        }
        OCSPReq request = SoftOperatorUtil.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL req = new URL(url);
        HttpURLConnection con = (HttpURLConnection)req.openConnection();
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Accept", "application/ocsp-response");
        con.setDoOutput(true);
        con.setConnectTimeout(3000);
        con.setReadTimeout(5000);
        OutputStream out = con.getOutputStream();
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
        dataOut.write(array);
        dataOut.flush();
        dataOut.close();
        if (con.getResponseCode() != 200) {
            throw new CryptOperatorException("ocsp\u54cd\u5e94\u5f02\u5e38,code\uff1a" + con.getResponseCode());
        }
        InputStream in = (InputStream)con.getContent();
        return new OCSPResp(in);
    }

    public static BigInteger[] derSignatureDecode(byte[] encoding) throws IOException {
        BigInteger[] bigIntegerArray;
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = SoftOperatorUtil.derSignatureEncode(r, s = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])expectedEncoding, (byte[])encoding)) {
            bigIntegerArray = null;
        } else {
            BigInteger[] bigIntegerArray2 = new BigInteger[2];
            bigIntegerArray2[0] = r;
            bigIntegerArray = bigIntegerArray2;
            bigIntegerArray2[1] = s;
        }
        return bigIntegerArray;
    }

    public static byte[] derSignatureEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }

    public static byte[][] sm2SignDerDecode(byte[] sign) throws IOException {
        return SoftOperatorUtil.signDerDecode(sign, 32, 32);
    }

    public static byte[][] signDerDecode(byte[] sign, int rLength, int sLength) throws IOException {
        ASN1Sequence var2 = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sign));
        if (var2.size() != 2) {
            return null;
        }
        BigInteger var3 = ASN1Integer.getInstance((Object)var2.getObjectAt(0)).getValue();
        BigInteger var4 = ASN1Integer.getInstance((Object)var2.getObjectAt(1)).getValue();
        return new byte[][]{SoftOperatorUtil.changeByteArrayLength(BigIntegers.asUnsignedByteArray((BigInteger)var3), rLength), SoftOperatorUtil.changeByteArrayLength(BigIntegers.asUnsignedByteArray((BigInteger)var4), rLength)};
    }

    public static byte[] derSignatureEncode(byte[] r, byte[] s) throws IOException {
        return SoftOperatorUtil.derSignatureEncode(BigIntegers.fromUnsignedByteArray((byte[])r), BigIntegers.fromUnsignedByteArray((byte[])s));
    }

    private static List<X509Certificate> getCertsByCertChain(String certChainPath) {
        try {
            String content = new String(Files.readAllBytes(Paths.get(certChainPath, new String[0])));
            content = content.replaceFirst("-----BEGIN PKCS7-----", "");
            content = content.replaceFirst("-----END PKCS7-----", "");
            content = content.replace("\r", "").replace("\n", "");
            content = content.replace("\\r", "").replace("\\n", "");
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
            CMSSignedData cmsSignedData = new CMSSignedData(Base64.getDecoder().decode(content));
            Store store = cmsSignedData.getCertificates();
            Collection collection = store.getMatches(null);
            for (X509CertificateHolder o : collection) {
                X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(o);
                certificateList.add(x509Certificate);
            }
            return certificateList;
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u9a8c\u8bc1\u8bc1\u4e66\u94fe\u5931\u8d25" + e.getMessage());
        }
    }

    public static void checkCertChain(String currentCert, String rootCertPath, String certChainPath) {
        if (StringUtils.isBlank((CharSequence)rootCertPath)) {
            throw new CryptOperatorException("\u6ca1\u6709\u627e\u5230\u6839\u8bc1\u4e66");
        }
        X509Certificate currentX509Certificate = SoftOperatorUtil.getCertFromStr(currentCert);
        Principal currentPrincipal = currentX509Certificate.getIssuerDN();
        boolean isInCertChain = false;
        try {
            X509Certificate X509certificateRoot = SoftOperatorUtil.readCertificateFromCer(rootCertPath);
            List<X509Certificate> x509CertificateList = SoftOperatorUtil.getCertsByCertChain(certChainPath);
            try {
                PublicKey publickey = X509certificateRoot.getPublicKey();
                x509CertificateList.get(0).verify(publickey);
            }
            catch (Exception e) {
                throw new CryptOperatorException("\u5f53\u524d\u8bc1\u4e66\u4e0d\u662f\u7531\u6839\u8bc1\u4e66\u7b7e\u53d1");
            }
            Principal principalLast = null;
            Date date = new Date();
            for (int i = 0; i < x509CertificateList.size(); ++i) {
                X509Certificate x509Certificate = x509CertificateList.get(i);
                Principal principalIssuer = x509Certificate.getIssuerDN();
                Principal principalSubject = x509Certificate.getSubjectDN();
                if (currentPrincipal.equals(principalSubject)) {
                    try {
                        currentX509Certificate.verify(x509Certificate.getPublicKey());
                    }
                    catch (Exception e) {
                        throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u6821\u9a8c\u5931\u8d25");
                    }
                    isInCertChain = true;
                }
                if (principalLast != null) {
                    if (principalIssuer.equals(principalLast)) {
                        try {
                            PublicKey publickey = x509CertificateList.get(i - 1).getPublicKey();
                            x509CertificateList.get(i).verify(publickey);
                            x509CertificateList.get(i).checkValidity(date);
                        }
                        catch (Exception e) {
                            throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u7684\u8bc1\u4e66");
                        }
                    } else {
                        throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u7684\u8bc1\u4e66");
                    }
                }
                principalLast = principalSubject;
            }
            if (!isInCertChain) {
                throw new CryptOperatorException("\u5f53\u524d\u8bc1\u4e66\u4e0d\u5728\u8bc1\u4e66\u94fe\u91cc\u9762");
            }
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        str = str.replace("\\r", "").replace("\\n", "");
        X509Certificate x509Cert = null;
        x509Cert = SoftOperatorUtil.getCertFromB64(str);
        if (x509Cert == null) {
            x509Cert = SoftOperatorUtil.getCertFromFullStr(str);
        }
        if (x509Cert == null) {
            x509Cert = SoftOperatorUtil.getCertFromStr16(str);
        }
        if (null == x509Cert) {
            throw new CryptOperatorException("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25");
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.getDecoder().decode(b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = SoftOperatorUtil.hex2byte(str);
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || "".equals(str)) {
            return new byte[0];
        }
        str = str.trim();
        StringBuilder sb = new StringBuilder(str);
        int len = sb.length();
        int binarySize = 2;
        if (len == 0 || len % binarySize == 1) {
            return new byte[0];
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += binarySize) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

