/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.usbkey;

import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.device.usbkey.ContainerEnum;
import com.xdja.cryptoappkit.device.usbkey.UsbKeyUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.sign.SignOperator;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.BigIntegers;

public class UsbKeySignOperator
implements SignOperator {
    CryptoAppKitProperties.UsbKey usbKey = CryptoAppKitProperties.getInstance().getUsbKey();
    private static final UsbKeySignOperator usbKeySignOperator = new UsbKeySignOperator();

    public static UsbKeySignOperator getInstance() {
        return usbKeySignOperator;
    }

    @Override
    public byte[] sm2sign(byte[] data) {
        try {
            Long handle = UsbKeyUtil.getHandle();
            if (null == handle) {
                throw new CryptOperatorException("\u83b7\u53d6\u8bbe\u5907\u53e5\u67c4\u5931\u8d25");
            }
            ContainerEnum containerEnum = ContainerEnum.getByContainerNum(this.usbKey.getContainerNum());
            if (null == containerEnum) {
                throw new CryptOperatorException("\u5bb9\u5668\u4e0d\u5b58\u5728");
            }
            byte[] sign = UsbKeyUtil.sm2sign(handle, this.usbKey.getUsbPin(), containerEnum.getSignPublicKeyId(), containerEnum.getSignPrivateKeyId(), data);
            byte[] r = new byte[32];
            byte[] s = new byte[32];
            assert (sign != null);
            System.arraycopy(sign, 0, r, 0, 32);
            System.arraycopy(sign, sign.length - 32, s, 0, 32);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])r)));
            v.add((ASN1Encodable)new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])s)));
            return new DERSequence(v).getEncoded("DER");
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u9a8c\u7b7e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public boolean sm2SignVerity(byte[] orgData, byte[] signData) {
        try {
            byte[] sign = this.getRealSign(signData, true);
            Long handle = UsbKeyUtil.getHandle();
            if (null == handle) {
                throw new CryptOperatorException("\u83b7\u53d6\u8bbe\u5907\u53e5\u67c4\u5931\u8d25");
            }
            ContainerEnum containerEnum = ContainerEnum.getByContainerNum(this.usbKey.getContainerNum());
            if (null == containerEnum) {
                throw new CryptOperatorException("\u5bb9\u5668\u4e0d\u5b58\u5728");
            }
            return UsbKeyUtil.sm2SignVerity(handle, this.usbKey.getUsbPin(), containerEnum.getSignPublicKeyId(), orgData, sign);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    @Override
    public boolean sm2SignVerity(String signCert, byte[] orgData, byte[] signData, boolean isUseAsn1Encode) {
        try {
            byte[] sign = this.getRealSign(signData, isUseAsn1Encode);
            Long handle = UsbKeyUtil.getHandle();
            if (null == handle) {
                throw new CryptOperatorException("\u83b7\u53d6\u8bbe\u5907\u53e5\u67c4\u5931\u8d25");
            }
            BCECPublicKey bcecPublicKey = (BCECPublicKey)SoftOperatorUtil.getPublicKeyByCert(signCert);
            XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
            byte[] x = SoftOperatorUtil.changeByteArrayLength(bcecPublicKey.getQ().getXCoord().getEncoded(), 32);
            byte[] y = SoftOperatorUtil.changeByteArrayLength(bcecPublicKey.getQ().getYCoord().getEncoded(), 32);
            xdja_sm2_pubkey.x = x;
            xdja_sm2_pubkey.y = y;
            return UsbKeyUtil.sm2VerifyByExternalPublicKey(handle, this.usbKey.getUsbPin(), xdja_sm2_pubkey, orgData, sign);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u5916\u90e8\u516c\u94a5\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    private byte[] getRealSign(byte[] signData, boolean isUseAsn1Encode) {
        byte[] sign = new byte[64];
        if (isUseAsn1Encode) {
            BigInteger[] integers = new BigInteger[]{};
            try {
                integers = SoftOperatorUtil.derSignatureDecode(signData);
            }
            catch (IOException e) {
                throw new CryptOperatorException("\u7b7e\u540dASN1\u89e3\u5bc6\u5931\u8d25");
            }
            assert (integers != null);
            BigInteger r = integers[0];
            BigInteger s = integers[1];
            System.arraycopy(r.toByteArray(), r.toByteArray().length - 32, sign, 0, 32);
            System.arraycopy(s.toByteArray(), s.toByteArray().length - 32, sign, 32, 32);
        } else {
            sign = signData;
        }
        return sign;
    }
}

