/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.domain.model;

import com.xdja.cryptoappkit.device.hsm.HsmCryptOperator;
import com.xdja.cryptoappkit.device.hsm.HsmSignOperator;
import com.xdja.cryptoappkit.device.soft.SoftCertOperator;
import com.xdja.cryptoappkit.device.soft.SoftCryptOperator;
import com.xdja.cryptoappkit.device.svs.SvsCertOperator;
import com.xdja.cryptoappkit.device.svs.SvsSignOperator;
import com.xdja.cryptoappkit.device.usbkey.UsbKeySignOperator;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.operator.cert.CertOperator;
import com.xdja.cryptoappkit.domain.operator.crypt.CryptOperator;
import com.xdja.cryptoappkit.domain.operator.sign.SignOperator;
import java.util.Base64;

public class CryptService {
    CryptOperator cryptOperator;
    SignOperator signOperator;
    CertOperator certOperator;
    KeyCache keyCache = KeyCache.getInstance();
    CryptoAppKitProperties cryptoAppKitProperties = CryptoAppKitProperties.getInstance();

    public CryptService() {
        if (1 == this.cryptoAppKitProperties.getHsmType()) {
            if (this.cryptoAppKitProperties.isUseSvs()) {
                this.certOperator = SvsCertOperator.getInstance();
                this.signOperator = SvsSignOperator.getInstance();
            } else {
                this.certOperator = SoftCertOperator.getInstance();
                this.signOperator = UsbKeySignOperator.getInstance();
            }
            this.cryptOperator = SoftCryptOperator.getInstance();
        } else {
            if (this.cryptoAppKitProperties.isUseSvs()) {
                this.certOperator = SvsCertOperator.getInstance();
                this.signOperator = SvsSignOperator.getInstance();
            } else {
                this.certOperator = SoftCertOperator.getInstance();
                this.signOperator = HsmSignOperator.getInstance();
            }
            this.cryptOperator = HsmCryptOperator.getInstance();
        }
    }

    public String sm2Sign(String data) {
        byte[] sign = this.signOperator.sm2sign(data.getBytes());
        return Base64.getEncoder().encodeToString(sign);
    }

    public boolean sm2SignVerity(String orgData, String sign) {
        return this.signOperator.sm2SignVerity(orgData.getBytes(), Base64.getDecoder().decode(sign));
    }

    public boolean sm2SignVerity(String signCert, String orgData, String sign, boolean signedByXdjaCardManage) {
        return this.signOperator.sm2SignVerity(signCert, orgData.getBytes(), Base64.getDecoder().decode(sign), !signedByXdjaCardManage);
    }

    public String sm4Encrypt(String data) {
        byte[] cipherText = this.cryptOperator.sm4Encrypt(Base64.getDecoder().decode(this.keyCache.getKey4SM4()), data.getBytes());
        return Base64.getEncoder().encodeToString(cipherText);
    }

    public String sm4Decrypt(String cipherText) {
        byte[] data = this.cryptOperator.sm4Decrypt(Base64.getDecoder().decode(this.keyCache.getKey4SM4()), Base64.getDecoder().decode(cipherText));
        return new String(data);
    }

    public String hmacSM3(String data) {
        byte[] hash = this.cryptOperator.hmacSM3(Base64.getDecoder().decode(this.keyCache.getKey4HmacSM3()), data.getBytes());
        return Base64.getEncoder().encodeToString(hash);
    }

    public String sm3(String data) {
        byte[] hash = this.cryptOperator.sm3(data.getBytes());
        return Base64.getEncoder().encodeToString(hash);
    }

    public boolean certVerity(String cert) {
        return this.certOperator.certVerify(cert);
    }
}

