/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.usecase.crypt;

import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.model.CryptService;
import org.apache.commons.lang3.StringUtils;

public class CryptOperatorUseCase {
    CryptService cryptService = new CryptService();

    public String sm2Sign(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm2Sign(data);
    }

    public boolean sm2SignVerity(String orgData, String sign) {
        if (StringUtils.isEmpty((CharSequence)orgData)) {
            throw new CryptOperatorException("orgData\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isEmpty((CharSequence)sign)) {
            throw new CryptOperatorException("sign\u7b7e\u540d\u503c\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm2SignVerity(orgData, sign);
    }

    public boolean sm2SignVerity(String signCert, String orgData, String sign, boolean signedByXdjaCardManager) {
        if (StringUtils.isEmpty((CharSequence)orgData)) {
            throw new CryptOperatorException("orgData\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isEmpty((CharSequence)sign)) {
            throw new CryptOperatorException("sign\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isEmpty((CharSequence)signCert)) {
            throw new CryptOperatorException("signCert\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm2SignVerity(signCert, orgData, sign, signedByXdjaCardManager);
    }

    public String sm4Encrypt(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm4Encrypt(data);
    }

    public String sm4Decrypt(String cipherText) {
        if (StringUtils.isEmpty((CharSequence)cipherText)) {
            throw new CryptOperatorException("cipherText\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm4Decrypt(cipherText);
    }

    public String hmacSM3(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.hmacSM3(data);
    }

    public String sm3(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm3(data);
    }

    public boolean certVerity(String cert) {
        if (StringUtils.isEmpty((CharSequence)cert)) {
            throw new CryptOperatorException("cert\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.certVerity(cert);
    }
}

