/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm.pool;

import com.xdja.cryptoappkit.device.hsm.pool.HsmConnection;
import com.xdja.cryptoappkit.device.hsm.pool.YunhsmSdfSDKUtils;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.hsm.api.SdfApi;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class HsmPooledObjectFactory
implements PooledObjectFactory<HsmConnection> {
    private volatile SdfApi sdfApi = new SdfApi();
    private volatile long[] dev = new long[]{0L};

    HsmPooledObjectFactory() {
        this.openDevice();
    }

    synchronized boolean isDeviceOpen() {
        return this.dev[0] != 0L;
    }

    synchronized void openDevice() {
        String configPath;
        if (!this.isDeviceOpen() && (configPath = YunhsmSdfSDKUtils.getConfigPath()) != null) {
            try {
                YunhsmSdfSDKUtils.openDevice(this.sdfApi, this.dev);
            }
            catch (CryptOperatorException cryptOperatorException) {
                // empty catch block
            }
            try {
                YunhsmSdfSDKUtils.initialize(this.sdfApi, this.dev, configPath);
            }
            catch (CryptOperatorException cryptOperatorException) {
                // empty catch block
            }
        }
    }

    synchronized void closeDevice() {
        if (this.dev[0] != 0L) {
            try {
                YunhsmSdfSDKUtils.closeDevice(this.sdfApi, this.dev);
            }
            catch (CryptOperatorException cryptOperatorException) {
                // empty catch block
            }
        }
        this.dev = new long[]{0L};
    }

    public PooledObject<HsmConnection> makeObject() {
        if (this.dev[0] == 0L) {
            this.openDevice();
        }
        HsmConnection connection = new HsmConnection(this.sdfApi, this.dev);
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<HsmConnection> pooledObject) throws Exception {
        HsmConnection connection = (HsmConnection)pooledObject.getObject();
        if (connection.isConnection()) {
            connection.close();
        }
    }

    public boolean validateObject(PooledObject<HsmConnection> pooledObject) {
        HsmConnection connection = (HsmConnection)pooledObject.getObject();
        return connection.isConnection();
    }

    public void activateObject(PooledObject<HsmConnection> pooledObject) throws Exception {
    }

    public void passivateObject(PooledObject<HsmConnection> pooledObject) throws Exception {
    }
}

