/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Store;

public class SoftOperatorUtil {
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    private static final String ALGORITHM = "SM3WithSM2";
    private static final String INIT_IV = "1234567812345678";
    private static final String PROVIDER_STR = "BC";
    private static final String SM2 = "sm2p256v1";
    public static final String ALGORITHM_SM4 = "SM4";
    public static final String ALGORITHM_NAME_CBC_PKCS7PADDING = "SM4/CBC/PKCS7Padding";
    public static final String ALGORITHM_NAME_SM2 = "SM2";

    public static byte[] genRandom(int len) {
        Random rd = new Random();
        byte[] arr = new byte[len];
        rd.nextBytes(arr);
        return arr;
    }

    public static byte[] sm2Encrypt(PublicKey publicKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_SM2, PROVIDER_STR);
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static byte[] sm2Decrypt(PrivateKey privateKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_SM2, PROVIDER_STR);
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static byte[] sm4Encrypt(byte[] key, byte[] data) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_SM4);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PKCS7PADDING, PROVIDER_STR);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(INIT_IV.getBytes());
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM4\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static boolean sm4Encrypt(byte[] key, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_SM4);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PKCS7PADDING, PROVIDER_STR);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(INIT_IV.getBytes());
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            SoftOperatorUtil.sm4FileExecute(cipher, fileInputStream, fileOutputStream);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM4\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        return true;
    }

    public static boolean sm4Decrypt(byte[] key, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_SM4);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PKCS7PADDING, PROVIDER_STR);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(INIT_IV.getBytes());
            cipher.init(2, (Key)secretKey, ivParameterSpec);
            SoftOperatorUtil.sm4FileExecute(cipher, fileInputStream, fileOutputStream);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM4\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        return true;
    }

    public static byte[] sm4Decrypt(byte[] key, byte[] data) {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM_SM4);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PKCS7PADDING, PROVIDER_STR);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(INIT_IV.getBytes());
            cipher.init(2, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM4\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static byte[] hmacWithSm3(byte[] key, byte[] data) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(data, 0, data.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static byte[] hmacWithSm3(byte[] key, FileInputStream fileInputStream) {
        byte[] byArray;
        block9: {
            KeyParameter keyParameter = new KeyParameter(key);
            SM3Digest digest = new SM3Digest();
            HMac mac = new HMac((Digest)digest);
            mac.init((CipherParameters)keyParameter);
            FileInputStream fis = fileInputStream;
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    mac.update(buffer, 0, bytesRead);
                }
                byte[] hash = new byte[digest.getDigestSize()];
                mac.doFinal(hash, 0);
                byArray = hash;
                if (fis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CryptOperatorException("HMAC-SM3\u6587\u4ef6\u5904\u7406\u5931\u8d25");
                }
            }
            fis.close();
        }
        return byArray;
    }

    public static byte[] sm3(byte[] data) {
        SM3Digest digest = new SM3Digest();
        digest.update(data, 0, data.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static byte[] sm3(FileInputStream fileInputStream) {
        byte[] byArray;
        block9: {
            SM3Digest digest = new SM3Digest();
            FileInputStream fis = fileInputStream;
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
                byte[] hash = new byte[digest.getDigestSize()];
                digest.doFinal(hash, 0);
                byArray = hash;
                if (fis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CryptOperatorException("SM3\u6587\u4ef6\u5904\u7406\u5931\u8d25");
                }
            }
            fis.close();
        }
        return byArray;
    }

    public static boolean verifySign(PublicKey publicKey, byte[] dataBytes, byte[] sign) {
        try {
            Signature signature = Signature.getInstance(ALGORITHM, PROVIDER_STR);
            signature.initVerify(publicKey);
            signature.update(dataBytes);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public static boolean verifySign(PublicKey publicKey, FileInputStream inputStream, byte[] sign) {
        boolean bl;
        block9: {
            FileInputStream fileInputStream = inputStream;
            try {
                int bytesRead;
                Signature signature = Signature.getInstance(ALGORITHM, PROVIDER_STR);
                signature.initVerify(publicKey);
                byte[] buffer = new byte[4096];
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    signature.update(buffer, 0, bytesRead);
                }
                bl = signature.verify(sign);
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CryptOperatorException(e.getMessage());
                }
            }
            fileInputStream.close();
        }
        return bl;
    }

    public static byte[] sm2Sign(PrivateKey privateKey, byte[] dataBytes) {
        try {
            Signature signature = Signature.getInstance(ALGORITHM, PROVIDER_STR);
            signature.initSign(privateKey);
            signature.update(dataBytes);
            return signature.sign();
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public static byte[] sm2Sign(PrivateKey privateKey, FileInputStream inputStream) {
        byte[] byArray;
        block9: {
            FileInputStream fileInputStream = inputStream;
            try {
                int bytesRead;
                Signature signature = Signature.getInstance(ALGORITHM, PROVIDER_STR);
                signature.initSign(privateKey);
                byte[] buffer = new byte[4096];
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    signature.update(buffer, 0, bytesRead);
                }
                byArray = signature.sign();
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CryptOperatorException(e.getMessage());
                }
            }
            fileInputStream.close();
        }
        return byArray;
    }

    public static PublicKey getPublicKeyByCert(String cert) {
        try {
            X509Certificate x509Certificate = SoftOperatorUtil.getCertFromStr(cert);
            return x509Certificate.getPublicKey();
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u4ece\u8bc1\u4e66\u4e2d\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
        }
    }

    public static X509Certificate getX509CertificateByCert(String cert) {
        try {
            cert = cert.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
            cert = cert.replace("\r", "").replace("\n", "");
            cert = cert.replace("\\r", "").replace("\\n", "");
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509", PROVIDER_STR);
            byte[] pkByte = Base64.getDecoder().decode(cert);
            return (X509Certificate)certificatefactory.generateCertificate(new ByteArrayInputStream(pkByte));
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new CryptOperatorException("\u89e3\u6790\u8bc1\u4e66\u5931\u8d25");
        }
    }

    public static byte[] changeByteArrayLength(byte[] bb, int len) {
        if (bb.length == len) {
            return bb;
        }
        return bb.length < len ? SoftOperatorUtil.fillByteArrayWithZeroInHead(bb, len) : SoftOperatorUtil.filterByteArrayZeroInHead(bb, len);
    }

    public static byte[] fillByteArrayWithZeroInHead(byte[] ss, int len) {
        if (ss.length == len) {
            return ss;
        }
        byte[] bs = new byte[len];
        java.util.Arrays.fill(bs, (byte)0);
        System.arraycopy(ss, 0, bs, len - ss.length, ss.length);
        return bs;
    }

    public static byte[] filterByteArrayZeroInHead(byte[] ss, int len) {
        if (ss.length < len) {
            return ss;
        }
        byte[] bs = new byte[len];
        System.arraycopy(ss, ss.length - len, bs, 0, len);
        return bs;
    }

    public static X509Certificate readCertificateFromCer(String path) throws Exception {
        InputStream systemResourceAsStream = SoftOperatorUtil.readInputStreamFromPath(path);
        return SoftOperatorUtil.readCertificateFromCerInputStream(systemResourceAsStream);
    }

    public static X509Certificate readCertificateFromCerInputStream(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509", PROVIDER_STR);
        return (X509Certificate)factory.generateCertificate(inputStream);
    }

    public static InputStream readInputStreamFromPath(String filename) throws FileNotFoundException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(filename);
        if (inputStream == null) {
            inputStream = new FileInputStream(filename);
        }
        return inputStream;
    }

    public static byte[] lookupCrl(DirContext ctx, String crlDn, String crlAttrName) throws Exception {
        DirContext dirContext = (DirContext)ctx.lookup(crlDn);
        Attributes attributes = dirContext.getAttributes("");
        return (byte[])attributes.get(crlAttrName).get();
    }

    public static void saveCrlFile(byte[] crlByte, String filePath) {
        try (FileOutputStream output = new FileOutputStream(filePath + "crl.crl");
             BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);){
            bufferedOutput.write(crlByte);
            bufferedOutput.flush();
            output.flush();
        }
        catch (Exception e) {
            throw new CryptOperatorException("crl\u6587\u4ef6\u5199\u5165\u5931\u8d25");
        }
    }

    public static List<X509CRL> getCrlList(String crlFilePath) {
        try {
            ArrayList<X509CRL> list = new ArrayList<X509CRL>();
            FileInputStream fileInputStream = new FileInputStream(crlFilePath + "crl.crl");
            CertificateFactory cf = CertificateFactory.getInstance("X.509", PROVIDER_STR);
            X509CRL crl = (X509CRL)cf.generateCRL(fileInputStream);
            if (crl.getNextUpdate().compareTo(new Date()) > 0) {
                list.add(crl);
                return list;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, OperatorException, CertificateEncodingException {
        CertificateID id = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
        OCSPReqBuilder generator = new OCSPReqBuilder();
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Vector<ASN1ObjectIdentifier> objectIdentifiers = new Vector<ASN1ObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        objectIdentifiers.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(nonce.toByteArray())));
        generator.setRequestExtensions(Extensions.getInstance((Object)new X509Extensions(objectIdentifiers, values)));
        generator.addRequest(id);
        return generator.build();
    }

    public static OCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, OCSPException, IOException, OperatorException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            return null;
        }
        OCSPReq request = SoftOperatorUtil.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL req = new URL(url);
        HttpURLConnection con = (HttpURLConnection)req.openConnection();
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Accept", "application/ocsp-response");
        con.setDoOutput(true);
        con.setConnectTimeout(3000);
        con.setReadTimeout(5000);
        OutputStream out = con.getOutputStream();
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
        dataOut.write(array);
        dataOut.flush();
        dataOut.close();
        if (con.getResponseCode() != 200) {
            throw new CryptOperatorException("ocsp\u54cd\u5e94\u5f02\u5e38,code\uff1a" + con.getResponseCode());
        }
        InputStream in = (InputStream)con.getContent();
        return new OCSPResp(in);
    }

    public static BigInteger[] derSignatureDecode(byte[] encoding) throws IOException {
        BigInteger[] bigIntegerArray;
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = SoftOperatorUtil.derSignatureEncode(r, s = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])expectedEncoding, (byte[])encoding)) {
            bigIntegerArray = null;
        } else {
            BigInteger[] bigIntegerArray2 = new BigInteger[2];
            bigIntegerArray2[0] = r;
            bigIntegerArray = bigIntegerArray2;
            bigIntegerArray2[1] = s;
        }
        return bigIntegerArray;
    }

    public static byte[] derSignatureEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }

    public static byte[][] sm2SignDerDecode(byte[] sign) throws IOException {
        return SoftOperatorUtil.signDerDecode(sign, 32, 32);
    }

    public static byte[][] signDerDecode(byte[] sign, int rLength, int sLength) throws IOException {
        ASN1Sequence var2 = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sign));
        if (var2.size() != 2) {
            return null;
        }
        BigInteger var3 = ASN1Integer.getInstance((Object)var2.getObjectAt(0)).getValue();
        BigInteger var4 = ASN1Integer.getInstance((Object)var2.getObjectAt(1)).getValue();
        return new byte[][]{SoftOperatorUtil.changeByteArrayLength(BigIntegers.asUnsignedByteArray((BigInteger)var3), rLength), SoftOperatorUtil.changeByteArrayLength(BigIntegers.asUnsignedByteArray((BigInteger)var4), rLength)};
    }

    public static byte[] derSignatureEncode(byte[] r, byte[] s) throws IOException {
        return SoftOperatorUtil.derSignatureEncode(BigIntegers.fromUnsignedByteArray((byte[])r), BigIntegers.fromUnsignedByteArray((byte[])s));
    }

    private static List<X509Certificate> getCertsByCertChain(String certChainPath) {
        try {
            String content = new String(Files.readAllBytes(Paths.get(certChainPath, new String[0])));
            content = content.replaceFirst("-----BEGIN PKCS7-----", "");
            content = content.replaceFirst("-----END PKCS7-----", "");
            content = content.replace("\r", "").replace("\n", "");
            content = content.replace("\\r", "").replace("\\n", "");
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
            CMSSignedData cmsSignedData = new CMSSignedData(Base64.getDecoder().decode(content));
            Store store = cmsSignedData.getCertificates();
            Collection collection = store.getMatches(null);
            for (X509CertificateHolder o : collection) {
                X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(PROVIDER_STR).getCertificate(o);
                certificateList.add(x509Certificate);
            }
            return certificateList;
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u9a8c\u8bc1\u8bc1\u4e66\u94fe\u5931\u8d25" + e.getMessage());
        }
    }

    public static void checkCertChain(String certToBeVerify, String rootCertPath, String certChainPath) {
        X509Certificate certificateToBeVerify = SoftOperatorUtil.getCertFromStr(certToBeVerify);
        try {
            certificateToBeVerify.checkValidity(new Date());
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u5f85\u6821\u9a8c\u8bc1\u4e66\u5df2\u8fc7\u671f");
        }
        if (StringUtils.isBlank((CharSequence)rootCertPath) || StringUtils.isBlank((CharSequence)certChainPath)) {
            return;
        }
        Principal issuerDNOfTBV = certificateToBeVerify.getIssuerDN();
        boolean isInCertChain = false;
        try {
            List<X509Certificate> certList = SoftOperatorUtil.getCertsByCertChain(certChainPath);
            try {
                X509Certificate rootCert = SoftOperatorUtil.readCertificateFromCer(rootCertPath);
                PublicKey rootPubKey = rootCert.getPublicKey();
                certList.get(0).verify(rootPubKey);
            }
            catch (Exception e) {
                throw new CryptOperatorException("\u5f53\u524d\u8bc1\u4e66\u4e0d\u662f\u7531\u6839\u8bc1\u4e66\u7b7e\u53d1");
            }
            Principal prevSubjectDN = null;
            Date date = new Date();
            for (int i = 0; i < certList.size(); ++i) {
                X509Certificate cert = certList.get(i);
                Principal issuerDN = cert.getIssuerDN();
                Principal subjectDN = cert.getSubjectDN();
                if (prevSubjectDN != null) {
                    if (issuerDN.equals(prevSubjectDN)) {
                        try {
                            PublicKey publickey = certList.get(i - 1).getPublicKey();
                            certList.get(i).verify(publickey);
                            certList.get(i).checkValidity(date);
                        }
                        catch (Exception e) {
                            throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u7684\u8bc1\u4e66");
                        }
                    } else {
                        throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u7684\u8bc1\u4e66");
                    }
                }
                prevSubjectDN = subjectDN;
                if (!issuerDNOfTBV.equals(subjectDN)) continue;
                try {
                    certificateToBeVerify.verify(cert.getPublicKey());
                }
                catch (Exception e) {
                    throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u6821\u9a8c\u5931\u8d25");
                }
                isInCertChain = true;
                break;
            }
            if (!isInCertChain) {
                throw new CryptOperatorException("\u8bc1\u4e66\u94fe\u4e0d\u5305\u542b\u88ab\u6821\u9a8c\u8bc1\u4e66\u7684\u9881\u53d1\u8005");
            }
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = SoftOperatorUtil.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = SoftOperatorUtil.getCertFromFullStr(str);
        }
        if (x509Cert == null) {
            x509Cert = SoftOperatorUtil.getCertFromStr16(str);
        }
        if (null == x509Cert) {
            throw new CryptOperatorException("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25");
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", PROVIDER_STR);
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", PROVIDER_STR);
            byte[] bsCert = Base64.getDecoder().decode(b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = SoftOperatorUtil.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", PROVIDER_STR);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || "".equals(str)) {
            return new byte[0];
        }
        str = str.trim();
        StringBuilder sb = new StringBuilder(str);
        int len = sb.length();
        int binarySize = 2;
        if (len == 0 || len % binarySize == 1) {
            return new byte[0];
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += binarySize) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] preSm3(PublicKey publicKey, byte[] userID) {
        SM3Digest digest = new SM3Digest();
        digest.reset();
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        ECPoint ecPoint = ecPublicKey.getQ();
        ECParameterSpec ecParams = ecPublicKey.getParameters();
        SoftOperatorUtil.addFieldElement((Digest)digest, ecParams.getCurve().getA());
        SoftOperatorUtil.addFieldElement((Digest)digest, ecParams.getCurve().getB());
        SoftOperatorUtil.addFieldElement((Digest)digest, ecParams.getG().getAffineXCoord());
        SoftOperatorUtil.addFieldElement((Digest)digest, ecParams.getG().getAffineYCoord());
        SoftOperatorUtil.addFieldElement((Digest)digest, ecPoint.getAffineXCoord());
        SoftOperatorUtil.addFieldElement((Digest)digest, ecPoint.getAffineYCoord());
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    private static void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = v.getEncoded();
        digest.update(p, 0, p.length);
    }

    public static ECPublicKey createECPublicKey(byte[] xBytes, byte[] yBytes) {
        try {
            X9ECParameters sm2Parameters = CustomNamedCurves.getByName((String)SM2);
            ECParameterSpec parameterSpec = new ECParameterSpec(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN(), sm2Parameters.getH());
            ECPoint ecPoint = sm2Parameters.getCurve().createPoint(new BigInteger(1, xBytes), new BigInteger(1, yBytes));
            ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(ecPoint, parameterSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", PROVIDER_STR);
            return (ECPublicKey)keyFactory.generatePublic((KeySpec)publicKeySpec);
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u516c\u94a5x,y\u8f6c\u516c\u94a5\u5bf9\u8c61\u5931\u8d25");
        }
    }

    private static void sm4FileExecute(Cipher cipher, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        try (FileInputStream inputFileStream = fileInputStream;
             FileOutputStream outputFileStream = fileOutputStream;){
            int bytesRead;
            byte[] inputBuffer = new byte[cipher.getBlockSize()];
            byte[] outputBuffer = new byte[cipher.getOutputSize(inputBuffer.length)];
            while ((bytesRead = inputFileStream.read(inputBuffer)) != -1) {
                int outputLength = cipher.update(inputBuffer, 0, bytesRead, outputBuffer, 0);
                if (outputLength <= 0) continue;
                outputFileStream.write(outputBuffer, 0, outputLength);
            }
            int finalOutputLength = cipher.doFinal(outputBuffer, 0);
            if (finalOutputLength > 0) {
                outputFileStream.write(outputBuffer, 0, finalOutputLength);
            }
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    static {
        if (Security.getProvider(PROVIDER_STR) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

