/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.svs;

import com.xdja.cryptoappkit.device.svs.SvsUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.operator.sign.SignOperator;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;

public class SvsSignOperator
implements SignOperator {
    static CryptoAppKitProperties.Svs svsProperties = CryptoAppKitProperties.getInstance().getSvs();
    private static final SvsSignOperator svsCertOperator = new SvsSignOperator();

    public static SvsSignOperator getInstance() {
        SvsUtil.setSdkConfPath(svsProperties.getSvsSdkConfPath());
        return svsCertOperator;
    }

    @Override
    public byte[] sm2Sign(byte[] data) {
        return SvsUtil.sm2Sign(svsProperties.getSignKeyIndex(), svsProperties.getSignKeyValue().getBytes(StandardCharsets.UTF_8), data);
    }

    @Override
    public byte[] sm2Sign(FileInputStream fileInputStream) {
        return SvsUtil.sm2Sign(svsProperties.getAppName().getBytes(StandardCharsets.UTF_8), svsProperties.getSignKeyIndex(), svsProperties.getSignKeyValue().getBytes(StandardCharsets.UTF_8), fileInputStream);
    }

    @Override
    public boolean sm2SignVerity(FileInputStream fileInputStream, byte[] signData) {
        return SvsUtil.sm2SignVerity(svsProperties.getAppName().getBytes(StandardCharsets.UTF_8), signData, fileInputStream);
    }

    @Override
    public boolean sm2SignVerity(byte[] orgData, byte[] signData) {
        return SvsUtil.sm2SignVerity(svsProperties.getAppName().getBytes(StandardCharsets.UTF_8), signData, orgData);
    }

    @Override
    public boolean sm2SignVerity(String signCert, byte[] orgData, byte[] signData, boolean isUseAsn1Encode) {
        return SvsUtil.sm2SignVerityByExternalCert(signCert, orgData, signData, isUseAsn1Encode);
    }
}

