/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.svs.pool;

import com.xdja.cryptoappkit.device.svs.SvsUtil;
import com.xdja.svs.api.XvfApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvsSdfSDKUtils {
    private static final Logger logger = LoggerFactory.getLogger(SvsSdfSDKUtils.class);

    public static void testConnection(String configPath) {
        if (configPath == null) {
            configPath = SvsSdfSDKUtils.getConfigPath();
        }
        long[] dev = new long[]{0L};
        long[] ses = new long[]{0L};
        XvfApi xvfApi = new XvfApi();
        SvsSdfSDKUtils.initialize(xvfApi, dev, configPath);
        SvsSdfSDKUtils.openSession(xvfApi, dev, ses);
        SvsSdfSDKUtils.closeSession(xvfApi, dev, ses);
        SvsSdfSDKUtils.closeDevice(xvfApi, dev);
    }

    public static String getConfigPath() {
        return SvsUtil.getSdkConfPath();
    }

    public static void checkRet(String method, int ret, long dev, long ses) {
        if (ret != 0) {
            logger.error("\u6570\u636e\u8fde\u63a5\u5931\u8d25\uff1a{}", (Object)ret);
        } else {
            logger.info(method + " success! dev = " + dev + " session = " + ses);
        }
    }

    public static void initialize(XvfApi xvfApi, long[] dev, String configPath) {
        int ret = xvfApi.initialize(configPath, dev);
        SvsSdfSDKUtils.checkRet("initialize", ret, dev[0], 0L);
    }

    public static void openSession(XvfApi xvfApi, long[] dev, long[] ses) {
        int ret = xvfApi.openSession(dev[0], ses);
        SvsSdfSDKUtils.checkRet("openSession", ret, dev[0], ses[0]);
    }

    public static void closeSession(XvfApi xvfApi, long[] dev, long[] ses) {
        xvfApi.closeSession(ses[0]);
    }

    public static void closeDevice(XvfApi xvfApi, long[] dev) {
        xvfApi.finalize(dev[0]);
    }
}

