/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.usbkey;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.device.usbkey.ContainerEnum;
import com.xdja.cryptoappkit.device.usbkey.UsbKeyUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.bean.KeyInfo;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.keymanage.KeyManageOperator;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class UsbKeyManageOperator
implements KeyManageOperator {
    private static final UsbKeyManageOperator usbKeyManageOperator = new UsbKeyManageOperator();
    CryptoAppKitProperties.UsbKey usbKey = CryptoAppKitProperties.getInstance().getUsbKey();
    KeyCache keyCache = KeyCache.getInstance();
    private static final byte[] KEY_STORE_FILE_ID = new byte[]{0, 112};

    public static UsbKeyManageOperator getInstance() {
        return usbKeyManageOperator;
    }

    @Override
    public List<KeyInfo> initKey() {
        ArrayList<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
        int devNum = UsbKeyUtil.enumDev();
        if (devNum != 2) {
            throw new CryptOperatorException("\u679a\u4e3e\u8bbe\u5907\u5931\u8d25");
        }
        byte[] sm4Key = new byte[]{};
        byte[] hmacSm3Key = new byte[]{};
        for (int index = 0; index <= 1; ++index) {
            Long cardHandle = UsbKeyUtil.openDevice(index);
            if (null == cardHandle) {
                throw new CryptOperatorException("\u83b7\u53d6\u8bbe\u5907\u4f1a\u8bdd\u5931\u8d25");
            }
            if (index == 0) {
                UsbKeyUtil.setDeviceHandle(cardHandle);
                sm4Key = UsbKeyUtil.genRandom(cardHandle, 16);
                hmacSm3Key = UsbKeyUtil.genRandom(cardHandle, 32);
            }
            keyInfoList.addAll(this.initCard(cardHandle, sm4Key, hmacSm3Key));
        }
        this.keyCache.setKey4SM4(sm4Key);
        this.keyCache.setKey4HmacSM3(hmacSm3Key);
        return keyInfoList;
    }

    @Override
    public byte[] readFile(int length) {
        Long handle = UsbKeyUtil.getHandle();
        if (null == handle) {
            throw new CryptOperatorException("\u83b7\u53d6\u8bbe\u5907\u4f1a\u8bdd\u5931\u8d25");
        }
        return UsbKeyUtil.readFile(handle, KEY_STORE_FILE_ID, length);
    }

    @Override
    public byte[] sm2Decrypt(byte[] ciphertext) {
        Long handle = UsbKeyUtil.getHandle();
        if (null == handle) {
            throw new CryptOperatorException("\u83b7\u53d6\u8bbe\u5907\u4f1a\u8bdd\u5931\u8d25");
        }
        ContainerEnum containerEnum = ContainerEnum.getByContainerNum(this.usbKey.getContainerNum());
        assert (containerEnum != null);
        return UsbKeyUtil.sm2Decrypt(handle, this.usbKey.getUsbPin(), containerEnum.getEncryptPrivateKeyId(), ciphertext);
    }

    private List<KeyInfo> initCard(long cardHandle, byte[] sm4Key, byte[] hmacKey) {
        ContainerEnum containerEnum = ContainerEnum.getByContainerNum(this.usbKey.getContainerNum());
        ArrayList<KeyInfo> keyBackupList = new ArrayList<KeyInfo>();
        byte[] sm4KeyAndHmacSm3Key = ArrayUtils.addAll((byte[])sm4Key, (byte[])hmacKey);
        assert (containerEnum != null);
        byte[] KeyBySm2 = UsbKeyUtil.sm2Encrypt(cardHandle, this.usbKey.getUsbPin(), containerEnum.getEncryptPublicKeyId(), sm4KeyAndHmacSm3Key);
        byte[] hash = SoftOperatorUtil.sm3(sm4KeyAndHmacSm3Key);
        byte[] fileContext = ArrayUtils.addAll((byte[])KeyBySm2, (byte[])hash);
        UsbKeyUtil.createFile(cardHandle, this.usbKey.getUsbPin(), KEY_STORE_FILE_ID, fileContext.length);
        UsbKeyUtil.writeFile(cardHandle, this.usbKey.getUsbPin(), KEY_STORE_FILE_ID, fileContext);
        String cardId = new String(Objects.requireNonNull(UsbKeyUtil.getDeviceId(cardHandle)));
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setDeviceId(cardId);
        keyInfo.setHsmType(1);
        keyInfo.setEncryptedKeys(Base64.getEncoder().encodeToString(fileContext));
        keyInfo.setKeysHashBySM3(Base64.getEncoder().encodeToString(SoftOperatorUtil.sm3(fileContext)));
        return keyBackupList;
    }
}

