/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.usbkey;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;

public class UsbKeyUtil {
    private static Long deviceHandle;
    public static final int OK = 0;
    public static final int NO_HANDLE = -1;
    public static final byte FILE_READ = -16;
    public static final byte FILE_WRITE = -15;
    private static final JNIAPI jniapi;

    public static int enumDev() {
        int[] nDev = new int[1];
        int ret = jniapi.EnumDev(0, nDev);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u679a\u4e3e\u8bbe\u5907\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        int devNum = nDev[0];
        if (0 == devNum) {
            throw new CryptOperatorException("\u6ca1\u6709\u679a\u4e3e\u5230\u8bbe\u5907");
        }
        return devNum;
    }

    public static synchronized Long openDevice(int index) {
        int num = UsbKeyUtil.enumDev();
        if (num == 0) {
            throw new CryptOperatorException("\u6ca1\u6709\u679a\u4e3e\u5230\u8bbe\u5907");
        }
        long[] handleArr = new long[1];
        int ret = jniapi.OpenDev(index, handleArr);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u6253\u5f00\u8bbe\u5907\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return handleArr[0];
    }

    public static byte[] genRandom(long handle, int length) {
        byte[] data = new byte[length];
        int ret = jniapi.GenRandom(handle, length, data);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u751f\u6210\u968f\u673a\u6570\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return data;
    }

    private static void closeDevice(long handle) {
        jniapi.CloseDev(handle);
    }

    public static boolean verifyPin(long handle, String usbPin) {
        int ret = jniapi.VerifyPIN(handle, CryptoAppKitProperties.getInstance().getUsbKey().getUsbRole(), usbPin.getBytes(), usbPin.length());
        if (0 != ret) {
            throw new CryptOperatorException(ret, "PIN\u7801\u9a8c\u8bc1\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return true;
    }

    public static byte[] getDeviceId(long handle) {
        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();
        int ret = jniapi.GetDevInfo(handle, xdja_devinfo);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u83b7\u53d6\u8bbe\u5907ID\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return xdja_devinfo.cardid;
    }

    public static byte[] sm2Encrypt(long handle, String usbPin, byte[] encryptPublicKeyId, byte[] data) {
        if (!UsbKeyUtil.verifyPin(handle, usbPin)) {
            return null;
        }
        byte[] outData = new byte[data.length + 97];
        int[] outLen = new int[1];
        int ret = jniapi.SM2Encrypt(handle, encryptPublicKeyId, null, data, data.length, outData, outLen);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "sm2\u52a0\u5bc6\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        int realOutDataLen = outLen[0];
        byte[] realOutData = new byte[realOutDataLen];
        System.arraycopy(outData, 0, realOutData, 0, realOutDataLen);
        return realOutData;
    }

    public static boolean createFile(long handle, String usbPin, byte[] fileId, int fileSize) {
        XDJA_FILE xdja_file = new XDJA_FILE();
        UsbKeyUtil.verifyPin(handle, usbPin);
        xdja_file.id = fileId;
        xdja_file.read_Acl = (byte)-16;
        xdja_file.write_Acl = (byte)-15;
        xdja_file.room = (short)fileSize;
        xdja_file.type = 1;
        int ret = jniapi.CreateFile(handle, xdja_file);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return true;
    }

    public static boolean writeFile(long handle, String usbPin, byte[] storeKeyFileId, byte[] context) {
        UsbKeyUtil.verifyPin(handle, usbPin);
        int ret = jniapi.WriteFile(handle, storeKeyFileId, 0, context.length, context);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u5199\u6587\u4ef6\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return true;
    }

    public static byte[] readFile(long handle, byte[] storeKeyFileId, int length) {
        byte[] contextByte = new byte[length];
        int ret = jniapi.ReadFile(handle, storeKeyFileId, 0, contextByte.length, contextByte);
        if (0 != ret) {
            if (-20 == ret) {
                return null;
            }
            throw new CryptOperatorException(ret, "\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return contextByte;
    }

    public static byte[] sm2Decrypt(long handle, String usbPin, byte[] encryptPrivateKeyId, byte[] ciphertext) {
        if (!UsbKeyUtil.verifyPin(handle, usbPin)) {
            return null;
        }
        byte[] outData = new byte[ciphertext.length - 32];
        int[] outLen = new int[1];
        int ret = jniapi.SM2Decrypt(handle, encryptPrivateKeyId, ciphertext, ciphertext.length, outData, outLen);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "SM2\u89e3\u5bc6\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        int realOutDataLen = outLen[0];
        byte[] realOutData = new byte[realOutDataLen];
        System.arraycopy(outData, 0, realOutData, 0, realOutDataLen);
        return realOutData;
    }

    public static byte[] sm2sign(long handle, String usbPin, byte[] signPublicKeyId, byte[] signPrivateKeyId, byte[] data, int hashType) {
        if (!UsbKeyUtil.verifyPin(handle, usbPin)) {
            return null;
        }
        byte[] signBytes = new byte[64];
        int[] outLen = new int[1];
        int ret = jniapi.SM2Sign(handle, signPublicKeyId, signPrivateKeyId, hashType, data, data.length, signBytes, outLen);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "SM2\u7b7e\u540d\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        int realOutDataLen = outLen[0];
        byte[] realOutData = new byte[realOutDataLen];
        System.arraycopy(signBytes, 0, realOutData, 0, realOutDataLen);
        return realOutData;
    }

    public static boolean sm2SignVerity(long handle, String usbPin, byte[] encryptPublicKeyId, byte[] orgData, byte[] signData, int hashType) {
        if (!UsbKeyUtil.verifyPin(handle, usbPin)) {
            return false;
        }
        int ret = jniapi.SM2SignVerify(handle, encryptPublicKeyId, hashType, null, orgData, orgData.length, signData);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "\u9a8c\u7b7e\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return true;
    }

    public static boolean sm2VerifyByExternalPublicKey(long handle, String usbPin, XDJA_SM2_PUBKEY xdja_sm2_pubkey, byte[] orgData, byte[] signData) {
        if (!UsbKeyUtil.verifyPin(handle, usbPin)) {
            return false;
        }
        int ret = jniapi.SM2SignVerify(handle, new byte[]{0, 0}, 1, xdja_sm2_pubkey, orgData, orgData.length, signData);
        if (0 != ret) {
            throw new CryptOperatorException(ret, "SM2\u5916\u90e8\u516c\u94a5\u9a8c\u7b7e\u5931\u8d25\uff0cret\uff1a" + ret);
        }
        return true;
    }

    public static XDJA_SM2_PUBKEY getUsbKeyPublicKey(long cardHandle, byte[] signPublicKeyId) {
        XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
        int ret = jniapi.ReadSm2PubKey(cardHandle, signPublicKeyId, xdja_sm2_pubkey);
        if (ret == 0) {
            return xdja_sm2_pubkey;
        }
        throw new CryptOperatorException("\u5bfc\u51fa\u516c\u94a5\u5931\u8d25\uff1a{}" + ret);
    }

    public static synchronized Long getHandle() {
        if (null == deviceHandle) {
            return UsbKeyUtil.openDevice(0);
        }
        byte[] data = new byte[1];
        int ret = jniapi.GenRandom(deviceHandle, 1, data);
        if (ret == 0) {
            return deviceHandle;
        }
        if (ret == -1) {
            return UsbKeyUtil.openDevice(0);
        }
        throw new CryptOperatorException(ret, "\u751f\u6210\u53e5\u67c4\u5931\u8d25\uff0cret\uff1a" + ret);
    }

    public static synchronized void setDeviceHandle(long handle) {
        deviceHandle = handle;
    }

    static {
        jniapi = new JNIAPI();
    }
}

