/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.domain.model;

import com.xdja.cryptoappkit.device.hsm.HsmCryptOperator;
import com.xdja.cryptoappkit.device.hsm.HsmKeyManageOperator;
import com.xdja.cryptoappkit.device.soft.P12CertOperator;
import com.xdja.cryptoappkit.device.soft.SoftCryptOperator;
import com.xdja.cryptoappkit.device.soft.SoftKeyManageOperator;
import com.xdja.cryptoappkit.device.usbkey.UsbKeyManageOperator;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.bean.KeyInfo;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.crypt.CryptOperator;
import com.xdja.cryptoappkit.domain.operator.keymanage.KeyManageOperator;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KeyManageService {
    KeyManageOperator keyManageOperator;
    CryptOperator cryptOperator;
    KeyCache keyCache = KeyCache.getInstance();
    CryptoAppKitProperties cryptoAppKitProperties = CryptoAppKitProperties.getInstance();
    public static final int SM2_KEY_LENGTH = 145;
    public static final int SM3_KEY_LENGTH = 32;
    public static final int SM4_KEY_LENGTH = 16;

    public KeyManageService() {
        int hsmType = this.cryptoAppKitProperties.getHsmType();
        if (1 == hsmType) {
            this.keyManageOperator = UsbKeyManageOperator.getInstance();
            this.cryptOperator = SoftCryptOperator.getInstance();
        } else if (2 == hsmType) {
            this.keyManageOperator = HsmKeyManageOperator.getInstance();
            this.cryptOperator = HsmCryptOperator.getInstance();
        } else {
            this.keyManageOperator = SoftKeyManageOperator.getInstance();
            this.cryptOperator = SoftCryptOperator.getInstance();
            if (StringUtils.isNotEmpty((CharSequence)this.cryptoAppKitProperties.getSoft().getSignKeyStoreFile()) && StringUtils.isNotEmpty((CharSequence)this.cryptoAppKitProperties.getSoft().getEncKeyStoreFile())) {
                try {
                    P12CertOperator.getInstance().initCert();
                }
                catch (Exception e) {
                    throw new CryptOperatorException(e.getMessage());
                }
            } else {
                throw new CryptOperatorException("p12\u7b7e\u540d\u548c\u52a0\u5bc6\u8bc1\u4e66\u672a\u914d\u7f6e");
            }
        }
        byte[] fileContext = this.keyManageOperator.readFile(177);
        if (null == fileContext) {
            return;
        }
        if (fileContext.length <= 0) {
            return;
        }
        byte[] sm2Key = new byte[145];
        System.arraycopy(fileContext, 0, sm2Key, 0, 145);
        byte[] sm4KeyAndHmacKey = this.keyManageOperator.sm2Decrypt(sm2Key);
        byte[] sm3_hmacSm3Key = new byte[32];
        System.arraycopy(fileContext, 145, sm3_hmacSm3Key, 0, 32);
        byte[] realHmacSm3Key = this.cryptOperator.sm3(sm4KeyAndHmacKey);
        if (!Base64.getEncoder().encodeToString(sm3_hmacSm3Key).equals(Base64.getEncoder().encodeToString(realHmacSm3Key))) {
            throw new CryptOperatorException("\u5bc6\u94a5\u5df2\u7ecf\u53d8\u66f4");
        }
        byte[] sm4Key = new byte[16];
        System.arraycopy(sm4KeyAndHmacKey, 0, sm4Key, 0, sm4Key.length);
        byte[] hmacSm3Key = new byte[32];
        System.arraycopy(sm4KeyAndHmacKey, 16, hmacSm3Key, 0, hmacSm3Key.length);
        this.keyCache.setKey4SM4(sm4Key);
        this.keyCache.setKey4HmacSM3(hmacSm3Key);
    }

    public List<KeyInfo> initKey() {
        return this.keyManageOperator.initKey();
    }

    public boolean checkKeyInit() {
        byte[] fileContent = this.keyManageOperator.readFile(1);
        return null != fileContent && fileContent.length > 0;
    }
}

