/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.usecase.crypt;

import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.model.CryptService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.apache.commons.lang3.StringUtils;

public class CryptOperatorUseCase {
    CryptService cryptService = new CryptService();

    public String sm2Sign(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm2Sign(data);
    }

    public byte[] sm2Sign(byte[] data) {
        if (null == data) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm2Sign(data);
    }

    public byte[] sm2Sign(FileInputStream fileInputStream) {
        return this.cryptService.sm2Sign(fileInputStream);
    }

    public byte[] sm2SignByFilePath(String filePath) {
        try {
            return this.cryptService.sm2Sign(new FileInputStream(filePath));
        }
        catch (FileNotFoundException e) {
            throw new CryptOperatorException("\u6587\u4ef6\u7b7e\u540d\u5931\u8d25");
        }
    }

    public boolean sm2SignVerity(String orgData, String sign) {
        if (StringUtils.isEmpty((CharSequence)orgData)) {
            throw new CryptOperatorException("orgData\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isEmpty((CharSequence)sign)) {
            throw new CryptOperatorException("sign\u7b7e\u540d\u503c\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm2SignVerity(orgData, sign);
    }

    public boolean sm2SignVerity(byte[] orgData, byte[] sign) {
        if (null == orgData) {
            throw new CryptOperatorException("orgData\u4e0d\u80fd\u4e3anull");
        }
        if (null == sign) {
            throw new CryptOperatorException("sign\u7b7e\u540d\u503c\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm2SignVerity(orgData, sign);
    }

    public boolean sm2SignVerity(FileInputStream fileInputStream, byte[] sign) {
        if (null == fileInputStream) {
            throw new CryptOperatorException("fileInputStream\u4e0d\u80fd\u4e3anull");
        }
        if (null == sign) {
            throw new CryptOperatorException("sign\u7b7e\u540d\u503c\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm2SignVerity(fileInputStream, sign);
    }

    public boolean sm2SignVerity(String filePath, byte[] sign) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new CryptOperatorException("filePath\u4e0d\u80fd\u4e3anull");
        }
        if (null == sign) {
            throw new CryptOperatorException("sign\u7b7e\u540d\u503c\u4e0d\u80fd\u4e3anull");
        }
        try {
            return this.cryptService.sm2SignVerity(new FileInputStream(filePath), sign);
        }
        catch (FileNotFoundException e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public boolean sm2SignVerity(String signCert, String orgData, String sign, boolean signedByXdjaCardManager) {
        if (StringUtils.isEmpty((CharSequence)orgData)) {
            throw new CryptOperatorException("orgData\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isEmpty((CharSequence)sign)) {
            throw new CryptOperatorException("sign\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isEmpty((CharSequence)signCert)) {
            throw new CryptOperatorException("signCert\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm2SignVerity(signCert, orgData, sign, signedByXdjaCardManager);
    }

    public String sm4Encrypt(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm4Encrypt(data);
    }

    public byte[] sm4Encrypt(byte[] data) {
        if (null == data) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm4Encrypt(data);
    }

    public boolean sm4Encrypt(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        if (null == fileInputStream) {
            throw new CryptOperatorException("fileInputStream\u4e0d\u80fd\u4e3anull");
        }
        if (null == fileOutputStream) {
            throw new CryptOperatorException("fileOutputStream\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm4Encrypt(fileInputStream, fileOutputStream);
    }

    public boolean sm4Encrypt(String orgFilePath, String cipherFilePath) {
        if (StringUtils.isEmpty((CharSequence)orgFilePath)) {
            throw new CryptOperatorException("orgFilePath\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((CharSequence)cipherFilePath)) {
            throw new CryptOperatorException("cipherFilePath\u4e0d\u80fd\u4e3anull");
        }
        try {
            return this.cryptService.sm4Encrypt(new FileInputStream(orgFilePath), new FileOutputStream(cipherFilePath));
        }
        catch (FileNotFoundException e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public String sm4Decrypt(String cipherText) {
        if (StringUtils.isEmpty((CharSequence)cipherText)) {
            throw new CryptOperatorException("cipherText\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm4Decrypt(cipherText);
    }

    public byte[] sm4Decrypt(byte[] cipherText) {
        if (null == cipherText) {
            throw new CryptOperatorException("cipherText");
        }
        return this.cryptService.sm4Decrypt(cipherText);
    }

    public boolean sm4Decrypt(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        if (null == fileInputStream) {
            throw new CryptOperatorException("fileInputStream\u4e0d\u80fd\u4e3anull");
        }
        if (null == fileOutputStream) {
            throw new CryptOperatorException("fileOutputStream\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm4Decrypt(fileInputStream, fileOutputStream);
    }

    public boolean sm4Decrypt(String cipherFilePath, String orgFilePath) {
        if (StringUtils.isEmpty((CharSequence)orgFilePath)) {
            throw new CryptOperatorException("orgFilePath\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((CharSequence)cipherFilePath)) {
            throw new CryptOperatorException("cipherFilePath\u4e0d\u80fd\u4e3anull");
        }
        try {
            return this.cryptService.sm4Decrypt(new FileInputStream(cipherFilePath), new FileOutputStream(orgFilePath));
        }
        catch (FileNotFoundException e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public String hmacSM3(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.hmacSM3(data);
    }

    public byte[] hmacSM3(byte[] data) {
        if (null == data) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.hmacSM3(data);
    }

    public byte[] hmacSM3(FileInputStream fileInputStream) {
        if (null == fileInputStream) {
            throw new CryptOperatorException("fileInputStream\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.hmacSM3(fileInputStream);
    }

    public byte[] hmacSM3ByFilePath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new CryptOperatorException("filePath\u4e0d\u80fd\u4e3anull");
        }
        try {
            return this.cryptService.hmacSM3(new FileInputStream(filePath));
        }
        catch (FileNotFoundException e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public String sm3(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.sm3(data);
    }

    public byte[] sm3(byte[] data) {
        if (null == data) {
            throw new CryptOperatorException("data\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm3(data);
    }

    public byte[] sm3(FileInputStream fileInputStream) {
        if (null == fileInputStream) {
            throw new CryptOperatorException("fileInputStream\u4e0d\u80fd\u4e3anull");
        }
        return this.cryptService.sm3(fileInputStream);
    }

    public byte[] sm3ByFilePath(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new CryptOperatorException("filePath\u4e0d\u80fd\u4e3anull");
        }
        try {
            return this.cryptService.sm3(new FileInputStream(filePath));
        }
        catch (FileNotFoundException e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    public boolean certVerity(String cert) {
        if (StringUtils.isEmpty((CharSequence)cert)) {
            throw new CryptOperatorException("cert\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32");
        }
        return this.cryptService.certVerity(cert);
    }
}

