/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm;

import com.xdja.cryptoappkit.device.hsm.pool.HsmConnection;
import com.xdja.cryptoappkit.device.hsm.pool.HsmConnectionProviderImpl;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.hsm.api.alg.AlgId;
import com.xdja.hsm.api.bean.EccCipher;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.hsm.api.bean.EccSignature;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class HsmUtil {
    private static final int HSM_REP_SUCCESS = 0;
    private static final int HSM_FILE_NOT_EXIST = 0x1000012;
    private static final int HSM_FILE_EXIST = 0x100001A;
    private static String SDK_CONF_PATH;
    private static final String SIGN_USER_ID = "1234567812345678";
    private static final String SM4_CBC_INIT_IV = "1234567812345678";
    public static final int SM4_ENCRYPT = 1;
    public static final int SM4_DECRYPT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] genRandom(int length) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            byte[] data = new byte[length];
            int ret = connection.getSdfApi().generateRandom(connection.getSes()[0], length, data);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u751f\u6210\u968f\u673a\u6570\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sm2Encrypt(int index, byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            EccPublicKey eccPublicKey = new EccPublicKey();
            int ret = connection.getSdfApi().exportEncPublicKeyEcc(connection.getSes()[0], index, eccPublicKey);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u5bfc\u51fa\u52a0\u5bc6\u516c\u94a5\u5931\u8d25,ret\uff1a" + ret);
            }
            EccCipher eccCipher = new EccCipher();
            ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], AlgId.SGD_SM2, eccPublicKey, data, data.length, eccCipher);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u516c\u94a5\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = HsmUtil.eccCipherEncode(eccCipher);
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sm2Decrypt(int index, byte[] cipherText) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            EccCipher eccCipher = HsmUtil.eccCipherDecode(cipherText);
            byte[] data = new byte[cipherText.length];
            int[] lg = new int[1];
            int ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, eccCipher, data, lg);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] realData = new byte[lg[0]];
            System.arraycopy(data, 0, realData, 0, realData.length);
            byte[] byArray = realData;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFile(byte[] fileName, int fileSize) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            int ret = connection.getSdfApi().createFile(connection.getSes()[0], fileName, fileName.length, fileSize);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(byte[] fileName, byte[] fileContent) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            int ret = connection.getSdfApi().writeFile(connection.getSes()[0], fileName, fileName.length, 0, fileContent.length, fileContent);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u5199\u6587\u4ef6\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EccSignature sm2Sign(int signIndex, byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            EccSignature eccSignature = new EccSignature();
            byte[] hash = HsmUtil.preSm3(signIndex, null, data);
            int ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], signIndex, hash, hash.length, eccSignature);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + ret);
            }
            EccSignature eccSignature2 = eccSignature;
            return eccSignature2;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EccSignature sm2Sign(int signIndex, FileInputStream inputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            EccSignature eccSignature = new EccSignature();
            byte[] hash = HsmUtil.preSm3(signIndex, inputStream);
            int ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], signIndex, hash, hash.length, eccSignature);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + ret);
            }
            EccSignature eccSignature2 = eccSignature;
            return eccSignature2;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sm2SignVerity(int signIndex, EccSignature eccSignature, byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            byte[] hash = HsmUtil.preSm3(signIndex, null, data);
            int ret = connection.getSdfApi().internalVerifyEcc(connection.getSes()[0], signIndex, hash, hash.length, eccSignature);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sm2SignVerity(int signIndex, EccSignature eccSignature, FileInputStream fileInputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            byte[] hash = HsmUtil.preSm3(signIndex, fileInputStream);
            int ret = connection.getSdfApi().internalVerifyEcc(connection.getSes()[0], signIndex, hash, hash.length, eccSignature);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sm2SignVerityByExternalPk(EccPublicKey eccPublicKey, byte[] data, EccSignature eccSignature) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            byte[] hash = HsmUtil.preSm3(null, eccPublicKey, data);
            int ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], AlgId.SGD_SM2, eccPublicKey, hash, hash.length, eccSignature);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u5916\u90e8\u516c\u94a5\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static byte[] sm4Encrypt(byte[] key, byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        long handle = HsmUtil.getKeyHandle(connection, key);
        try {
            byte[] totalCipher;
            byte[] input = HsmUtil.padding(data, 1);
            long inLg = input.length;
            byte[] iv = "1234567812345678".getBytes();
            if (input.length > 4096) {
                int ret;
                int[] lg;
                byte[] cipher;
                byte[] inData;
                totalCipher = new byte[input.length];
                int count = (int)(inLg / 4096L);
                for (int i = 0; i < count; ++i) {
                    inData = new byte[4096];
                    System.arraycopy(input, i * 4096, inData, 0, 4096);
                    cipher = new byte[4096];
                    lg = new int[]{4096};
                    ret = connection.getSdfApi().encrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, cipher, lg);
                    if (ret != 0) {
                        throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                    }
                    System.arraycopy(cipher, 0, totalCipher, i * 4096, 4096);
                }
                int rem = input.length - count * 4096;
                if (input.length - count * 4096 > 0) {
                    inData = new byte[rem];
                    System.arraycopy(input, input.length - rem, inData, 0, rem);
                    cipher = new byte[rem];
                    lg = new int[]{rem};
                    ret = connection.getSdfApi().encrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, cipher, lg);
                    if (ret != 0) {
                        throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                    }
                    System.arraycopy(cipher, 0, totalCipher, count * 4096, rem);
                }
            } else {
                totalCipher = new byte[input.length];
                int ret = connection.getSdfApi().encrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, input, input.length, totalCipher, new int[]{input.length});
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
            }
            byte[] byArray = totalCipher;
            return byArray;
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
        finally {
            HsmUtil.releaseHandle(connection, handle);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static boolean sm4Encrypt(byte[] key, FileInputStream inputStream, FileOutputStream fileOutputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        long handle = HsmUtil.getKeyHandle(connection, key);
        byte[] iv = "1234567812345678".getBytes();
        boolean isPadding = false;
        try (FileInputStream fileInputStream = inputStream;
             FileOutputStream outputFileStream = fileOutputStream;){
            byte[] data;
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                if (bytesRead < 4096) {
                    data = new byte[bytesRead];
                    System.arraycopy(buffer, 0, data, 0, data.length);
                    buffer = HsmUtil.padding(data, 1);
                    bytesRead = buffer.length;
                    isPadding = true;
                }
                byte[] cipher = new byte[bytesRead];
                int ret = connection.getSdfApi().encrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, buffer, bytesRead, cipher, new int[]{bytesRead});
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                outputFileStream.write(cipher, 0, bytesRead);
            }
            if (!isPadding) {
                data = HsmUtil.padding(new byte[0], 1);
                byte[] cipher = new byte[data.length];
                int ret = connection.getSdfApi().encrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, buffer, bytesRead, cipher, new int[]{data.length});
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u52a0\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                outputFileStream.write(cipher, 0, cipher.length);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            throw new CryptOperatorException("\u52a0\u5bc6\u5931\u8d25");
        }
        finally {
            HsmUtil.releaseHandle(connection, handle);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
        return true;
    }

    public static byte[] sm4Decrypt(byte[] key, byte[] cipher) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        long handle = HsmUtil.getKeyHandle(connection, key);
        try {
            byte[] totalData;
            byte[] iv = "1234567812345678".getBytes();
            if (cipher.length > 4096) {
                int ret;
                int[] lg;
                byte[] outData;
                byte[] inData;
                totalData = new byte[cipher.length];
                int count = cipher.length / 4096;
                for (int i = 0; i < count; ++i) {
                    inData = new byte[4096];
                    System.arraycopy(cipher, i * 4096, inData, 0, 4096);
                    outData = new byte[4096];
                    lg = new int[]{4096};
                    ret = connection.getSdfApi().decrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, outData, lg);
                    if (ret != 0) {
                        throw new CryptOperatorException(ret, "SM4\u89e3\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                    }
                    System.arraycopy(outData, 0, totalData, i * 4096, 4096);
                }
                int rem = cipher.length - count * 4096;
                if (cipher.length - count * 4096 > 0) {
                    inData = new byte[rem];
                    System.arraycopy(cipher, cipher.length - rem, inData, 0, rem);
                    outData = new byte[rem];
                    lg = new int[]{rem};
                    ret = connection.getSdfApi().decrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, inData, inData.length, outData, lg);
                    if (ret != 0) {
                        throw new CryptOperatorException(ret, "SM4\u89e3\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                    }
                    System.arraycopy(outData, 0, totalData, count * 4096, rem);
                }
            } else {
                totalData = new byte[cipher.length];
                int ret = connection.getSdfApi().decrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, cipher, cipher.length, totalData, new int[]{totalData.length});
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u89e3\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
            }
            byte[] byArray = HsmUtil.padding(totalData, 2);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
        finally {
            HsmUtil.releaseHandle(connection, handle);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static boolean sm4Decrypt(byte[] key, FileInputStream inputStream, FileOutputStream fileOutputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        long handle = HsmUtil.getKeyHandle(connection, key);
        byte[] iv = "1234567812345678".getBytes();
        try (FileInputStream fileInputStream = inputStream;
             FileOutputStream outputFileStream = fileOutputStream;){
            int bytesRead;
            byte[] buffer = new byte[4096];
            byte[] lastBuffer = null;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                byte[] data = new byte[bytesRead];
                int ret = connection.getSdfApi().decrypt(connection.getSes()[0], handle, AlgId.SGD_SM4_CBC, iv, buffer, bytesRead, data, new int[]{bytesRead});
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "SM4\u89e3\u5bc6\u5931\u8d25,ret\uff1a" + ret);
                }
                if (null != lastBuffer) {
                    outputFileStream.write(lastBuffer, 0, lastBuffer.length);
                }
                lastBuffer = data;
            }
            byte[] input = HsmUtil.padding(lastBuffer, 2);
            if (null != input) {
                outputFileStream.write(input, 0, input.length);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            throw new CryptOperatorException(e.getMessage());
        }
        finally {
            HsmUtil.releaseHandle(connection, handle);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sm3(byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            int ret = connection.getSdfApi().hashInit(connection.getSes()[0], AlgId.SGD_SM3, null, null, 0);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            ret = connection.getSdfApi().hashUpdate(connection.getSes()[0], data, data.length);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] hash = new byte[32];
            ret = connection.getSdfApi().hashFinal(connection.getSes()[0], hash, new int[]{32});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = hash;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sm3(FileInputStream fileInputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            int ret = connection.getSdfApi().hashInit(connection.getSes()[0], AlgId.SGD_SM3, null, null, 0);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            try (FileInputStream fis = fileInputStream;){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    ret = connection.getSdfApi().hashUpdate(connection.getSes()[0], buffer, bytesRead);
                    if (ret == 0) continue;
                    throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
                }
            }
            catch (Exception e) {
                throw new CryptOperatorException("HSM \u6279\u91cf\u9884\u5904\u7406\u5931\u8d25");
            }
            byte[] hash = new byte[32];
            ret = connection.getSdfApi().hashFinal(connection.getSes()[0], hash, new int[]{32});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = hash;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static byte[] hmacSm3(byte[] key, byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        long handle = HsmUtil.getKeyHandle(connection, key);
        try {
            int ret = connection.getSdfApi().hmacInit(connection.getSes()[0], handle, AlgId.SGD_SM3);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            ret = connection.getSdfApi().hmacUpdate(connection.getSes()[0], data, data.length);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] hmacSM3 = new byte[32];
            ret = connection.getSdfApi().hmacFinal(connection.getSes()[0], hmacSM3, new int[]{32});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = hmacSM3;
            return byArray;
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
        finally {
            HsmUtil.releaseHandle(connection, handle);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static byte[] hmacSm3(byte[] key, FileInputStream fileInputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        long handle = HsmUtil.getKeyHandle(connection, key);
        try {
            int ret = connection.getSdfApi().hmacInit(connection.getSes()[0], handle, AlgId.SGD_SM3);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            try (FileInputStream fis = fileInputStream;){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    ret = connection.getSdfApi().hmacUpdate(connection.getSes()[0], buffer, bytesRead);
                    if (ret == 0) continue;
                    throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
                }
            }
            catch (Exception e) {
                throw new CryptOperatorException("HSM \u6279\u91cf\u9884\u5904\u7406\u5931\u8d25");
            }
            byte[] hmacSM3 = new byte[32];
            ret = connection.getSdfApi().hmacFinal(connection.getSes()[0], hmacSM3, new int[]{32});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "HMAC-SM3\u5904\u7406\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = hmacSM3;
            return byArray;
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
        finally {
            HsmUtil.releaseHandle(connection, handle);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    private static long getKeyHandle(HsmConnection connection, byte[] key) {
        long[] handles = new long[1];
        int ret = connection.getSdfApi().importKey(connection.getSes()[0], key, key.length, handles);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u5bfc\u5165\u5bc6\u94a5\u5931\u8d25,ret\uff1a" + ret);
        }
        return handles[0];
    }

    private static void releaseHandle(HsmConnection connection, long handle) {
        int ret = connection.getSdfApi().destroyKey(connection.getSes()[0], handle);
        if (ret != 0) {
            throw new CryptOperatorException(ret, "\u91ca\u653e\u4f1a\u8bdd\u53e5\u67c4\u5931\u8d25,ret\uff1a" + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(byte[] fileName, int length) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            int[] lg = new int[]{length};
            byte[] fileContent = new byte[length];
            int ret = connection.getSdfApi().readFile(connection.getSes()[0], fileName, fileName.length, 0, lg, fileContent);
            if (ret != 0) {
                if (0x1000012 == ret) {
                    byte[] byArray = null;
                    return byArray;
                }
                throw new CryptOperatorException(ret, "\u8bfb\u6587\u4ef6\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = fileContent;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] preSm3(Integer signIndex, EccPublicKey eccPublicKey, byte[] data) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            int ret;
            if (null == eccPublicKey) {
                eccPublicKey = new EccPublicKey();
                ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], signIndex.intValue(), eccPublicKey);
                if (ret != 0) {
                    throw new CryptOperatorException(ret, "\u7b7e\u540d\u516c\u94a5\u5bfc\u51fa\u5931\u8d25,ret\uff1a" + ret);
                }
            }
            if ((ret = connection.getSdfApi().hashInit(connection.getSes()[0], AlgId.SGD_SM3, eccPublicKey, "1234567812345678".getBytes(), "1234567812345678".getBytes().length)) != 0) {
                throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            ret = connection.getSdfApi().hashUpdate(connection.getSes()[0], data, data.length);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] hash = new byte[32];
            ret = connection.getSdfApi().hashFinal(connection.getSes()[0], hash, new int[]{32});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = hash;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] preSm3(Integer signIndex, FileInputStream fileInputStream) {
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        try {
            EccPublicKey eccPublicKey = new EccPublicKey();
            int ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], signIndex.intValue(), eccPublicKey);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u7b7e\u540d\u516c\u94a5\u5bfc\u51fa\u5931\u8d25,ret\uff1a" + ret);
            }
            ret = connection.getSdfApi().hashInit(connection.getSes()[0], AlgId.SGD_SM3, eccPublicKey, "1234567812345678".getBytes(), "1234567812345678".getBytes().length);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7b2c\u4e00\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            try (FileInputStream fis = fileInputStream;){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    ret = connection.getSdfApi().hashUpdate(connection.getSes()[0], buffer, bytesRead);
                    if (ret == 0) continue;
                    throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e8c\u6b65\u5931\u8d25,ret\uff1a" + ret);
                }
            }
            catch (Exception e) {
                throw new CryptOperatorException("HSM \u6279\u91cf\u9884\u5904\u7406\u5931\u8d25");
            }
            byte[] hash = new byte[32];
            ret = connection.getSdfApi().hashFinal(connection.getSes()[0], hash, new int[]{32});
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM3\u9884\u5904\u7406\u7684\u7b2c\u4e09\u6b65\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] byArray = hash;
            return byArray;
        }
        finally {
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static void setSdkConfPath(String path) {
        SDK_CONF_PATH = path;
    }

    public static String getSdkConfPath() {
        return SDK_CONF_PATH;
    }

    private static byte[] padding(byte[] input, int mode) {
        byte[] ret;
        if (input == null) {
            return null;
        }
        if (mode == 1) {
            int p = 16 - input.length % 16;
            ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            for (int i = 0; i < p; ++i) {
                ret[input.length + i] = (byte)p;
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }

    private static byte[] eccCipherEncode(EccCipher eccCipher) {
        byte[] x = new byte[32];
        System.arraycopy(eccCipher.getX(), 32, x, 0, 32);
        byte[] y = new byte[32];
        System.arraycopy(eccCipher.getY(), 32, y, 0, 32);
        byte[] m = eccCipher.getM();
        byte[] c = eccCipher.getC();
        byte[] l = HsmUtil.intToBytes(eccCipher.getL());
        byte[] encode = new byte[x.length + y.length + m.length + c.length + l.length];
        System.arraycopy(x, 0, encode, 0, x.length);
        System.arraycopy(y, 0, encode, x.length, y.length);
        System.arraycopy(m, 0, encode, x.length + y.length, m.length);
        System.arraycopy(l, 0, encode, x.length + y.length + m.length, l.length);
        System.arraycopy(c, 0, encode, x.length + y.length + m.length + l.length, c.length);
        System.out.println("eccCipherEncode encode" + encode.length);
        return encode;
    }

    private static EccCipher eccCipherDecode(byte[] encode) {
        System.out.println("eccCipherDecode encode" + encode.length);
        EccCipher eccCipher = new EccCipher();
        byte[] x = eccCipher.getX();
        System.arraycopy(encode, 0, x, 32, 32);
        byte[] y = eccCipher.getY();
        System.arraycopy(encode, 32, y, 32, 32);
        byte[] m = eccCipher.getM();
        System.arraycopy(encode, 64, m, 0, 32);
        byte[] l = new byte[4];
        System.arraycopy(encode, 96, l, 0, 1);
        int cl = HsmUtil.bytesToInt(l);
        byte[] c = new byte[cl];
        System.arraycopy(encode, 97, c, 0, cl);
        eccCipher.setX(x);
        eccCipher.setY(y);
        eccCipher.setM(m);
        eccCipher.setL(cl);
        eccCipher.setC(c);
        return eccCipher;
    }

    private static byte[] intToBytes(int a) {
        byte[] ans = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ans[i] = (byte)(a >> i * 8);
        }
        return new byte[]{ans[0]};
    }

    public static int bytesToInt(byte[] a) {
        int ans = 0;
        for (int i = 0; i < 4; ++i) {
            ans <<= 8;
            ans |= a[3 - i] & 0xFF;
        }
        return ans;
    }

    static {
        HsmConnectionProviderImpl.getInstance();
    }
}

