/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm.pool;

import com.xdja.cryptoappkit.device.hsm.pool.YunhsmSdfSDKUtils;
import com.xdja.hsm.api.SdfApi;

public class HsmConnection {
    private SdfApi sdfApi;
    private long[] dev;
    private volatile long[] ses = new long[]{0L};
    private int id;
    private long startTime;

    public HsmConnection(SdfApi sdfApi, long[] dev) {
        this.sdfApi = sdfApi;
        this.dev = dev;
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, this.ses);
    }

    public SdfApi getSdfApi() {
        return this.sdfApi;
    }

    public long[] getDev() {
        return this.dev;
    }

    public long[] getSes() {
        return this.ses;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void reopen() {
        YunhsmSdfSDKUtils.closeSession(this.sdfApi, this.dev, this.ses);
        this.ses = new long[]{0L};
        YunhsmSdfSDKUtils.openSession(this.sdfApi, this.dev, this.ses);
    }

    public synchronized void close() {
        YunhsmSdfSDKUtils.closeSession(this.sdfApi, this.dev, this.ses);
        this.ses = new long[]{0L};
    }

    public String getDeviceInfo() {
        return YunhsmSdfSDKUtils.getDeviceInfo(this.sdfApi, this.dev, this.ses);
    }

    public boolean isConnection() {
        if (this.ses.length != 1 || this.ses[0] == 0L || this.dev.length != 1 || this.dev[0] == 0L) {
            return false;
        }
        try {
            YunhsmSdfSDKUtils.getDeviceInfo(this.sdfApi, this.dev, this.ses);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

