/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm.pool;

import com.xdja.cryptoappkit.device.hsm.pool.HsmConnection;
import com.xdja.cryptoappkit.device.hsm.pool.HsmConnectionProvider;
import com.xdja.cryptoappkit.device.hsm.pool.HsmPooledObjectFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class HsmConnectionProviderImpl
implements HsmConnectionProvider {
    private GenericObjectPool<HsmConnection> genericObjectPool;
    private volatile HsmPooledObjectFactory factory = new HsmPooledObjectFactory();

    private HsmConnectionProviderImpl() {
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.factory);
        this.initPool();
    }

    private void initPool() {
        int maxTotal = 8;
        int maxIdle = 2;
        int minIdle = 1;
        this.genericObjectPool.setMaxTotal(maxTotal);
        this.genericObjectPool.setMaxIdle(maxIdle);
        this.genericObjectPool.setMinIdle(minIdle);
        this.genericObjectPool.setTestWhileIdle(true);
        this.genericObjectPool.setNumTestsPerEvictionRun(-1);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(300000L);
        if (this.factory.isDeviceOpen()) {
            try {
                this.genericObjectPool.preparePool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public HsmConnection getConnection() {
        try {
            if (this.genericObjectPool.getNumWaiters() > 0) {
                // empty if block
            }
            return (HsmConnection)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException("getConnection error", e);
        }
    }

    @Override
    public void releaseConnection(HsmConnection connection) {
        try {
            this.genericObjectPool.returnObject((Object)connection);
            if (this.genericObjectPool.getNumWaiters() > 0) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String string = stackTrace[3].getMethodName();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("releaseConnection error", e);
        }
    }

    public synchronized void clear() {
        this.genericObjectPool.clear();
        this.factory.closeDevice();
    }

    public synchronized void reopen() throws Exception {
        this.clear();
        this.factory.openDevice();
        this.genericObjectPool.preparePool();
    }

    public static synchronized HsmConnectionProviderImpl getInstance() {
        return ConnectionProviderHolder.INSTANCE;
    }

    private static class ConnectionProviderHolder {
        private static final HsmConnectionProviderImpl INSTANCE = new HsmConnectionProviderImpl();

        private ConnectionProviderHolder() {
        }
    }
}

