/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.hsm.pool;

import com.xdja.cryptoappkit.device.hsm.HsmUtil;
import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.bean.DeviceInfo;

public class YunhsmSdfSDKUtils {
    public static void testConnection(String configPath) {
        if (configPath == null) {
            configPath = YunhsmSdfSDKUtils.getConfigPath();
        }
        long[] dev = new long[]{0L};
        long[] ses = new long[]{0L};
        SdfApi sdfApi = new SdfApi();
        YunhsmSdfSDKUtils.openDevice(sdfApi, dev);
        YunhsmSdfSDKUtils.initialize(sdfApi, dev, configPath);
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, ses);
        YunhsmSdfSDKUtils.getDeviceInfo(sdfApi, dev, ses);
        YunhsmSdfSDKUtils.closeSession(sdfApi, dev, ses);
        YunhsmSdfSDKUtils.closeDevice(sdfApi, dev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPrivateKeyAccess(int index, String password) {
        boolean bl;
        SdfApi sdfApi = new SdfApi();
        String configPath = YunhsmSdfSDKUtils.getConfigPath();
        long[] dev = new long[]{0L};
        long[] ses = new long[]{0L};
        YunhsmSdfSDKUtils.openDevice(sdfApi, dev);
        YunhsmSdfSDKUtils.initialize(sdfApi, dev, configPath);
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, ses);
        try {
            int accessRight = sdfApi.getPrivateKeyAccessRight(ses[0], index, password.getBytes(), password.length());
            YunhsmSdfSDKUtils.checkRet("getPrivateKeyAccessRight", accessRight, dev[0], ses[0]);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    YunhsmSdfSDKUtils.closeSession(sdfApi, dev, ses);
                    YunhsmSdfSDKUtils.closeDevice(sdfApi, dev);
                    throw throwable;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            YunhsmSdfSDKUtils.closeSession(sdfApi, dev, ses);
            YunhsmSdfSDKUtils.closeDevice(sdfApi, dev);
            return bl2;
        }
        YunhsmSdfSDKUtils.closeSession(sdfApi, dev, ses);
        YunhsmSdfSDKUtils.closeDevice(sdfApi, dev);
        return bl;
    }

    public static String getConfigPath() {
        return HsmUtil.getSdkConfPath();
    }

    public static void checkRet(String method, int ret, long dev, long ses) {
        if (ret != 0) {
            // empty if block
        }
    }

    public static void openDevice(SdfApi sdfApi, long[] dev) {
        int ret = sdfApi.openDevice(dev);
        YunhsmSdfSDKUtils.checkRet("openDevice", ret, dev[0], 0L);
    }

    public static void openDeviceWithPath(SdfApi sdfApi, String path, long[] dev) {
        int ret = sdfApi.openDeviceWithPath(path, dev);
        YunhsmSdfSDKUtils.checkRet("openDevice with path  " + path, ret, dev[0], 0L);
    }

    public static void initialize(SdfApi sdfApi, long[] dev, String configPath) {
        int ret = sdfApi.initialize(dev[0], configPath.getBytes());
        YunhsmSdfSDKUtils.checkRet("initialize", ret, dev[0], 0L);
    }

    public static void openSession(SdfApi sdfApi, long[] dev, long[] ses) {
        int ret = sdfApi.openSession(dev[0], ses);
        YunhsmSdfSDKUtils.checkRet("openSession", ret, dev[0], ses[0]);
    }

    public static void closeSession(SdfApi sdfApi, long[] dev, long[] ses) {
        int ret = sdfApi.closeSession(ses[0]);
        YunhsmSdfSDKUtils.checkRet("closeSession", ret, dev[0], ses[0]);
    }

    public static void closeDevice(SdfApi sdfApi, long[] dev) {
        int ret = sdfApi.closeDevice(dev[0]);
        YunhsmSdfSDKUtils.checkRet("closeDevice", ret, dev[0], 0L);
    }

    public static String getDeviceInfo(SdfApi sdfApi, long[] dev, long[] ses) {
        DeviceInfo deviceInfo = new DeviceInfo();
        int ret = sdfApi.getDeviceInfo(ses[0], deviceInfo);
        YunhsmSdfSDKUtils.checkRet("getDeviceInfo", ret, dev[0], ses[0]);
        return deviceInfo.toString();
    }
}

