/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.crypt.CryptOperator;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class SoftCryptOperator
implements CryptOperator {
    private static final SoftCryptOperator softCryptOperator = new SoftCryptOperator();

    public static SoftCryptOperator getInstance() {
        return softCryptOperator;
    }

    @Override
    public byte[] sm4Encrypt(byte[] key, byte[] data) {
        return SoftOperatorUtil.sm4Encrypt(key, data);
    }

    @Override
    public boolean sm4Encrypt(byte[] key, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        return SoftOperatorUtil.sm4Encrypt(key, fileInputStream, fileOutputStream);
    }

    @Override
    public byte[] sm4Decrypt(byte[] key, byte[] cipherText) {
        try {
            return SoftOperatorUtil.sm4Decrypt(key, cipherText);
        }
        catch (Exception e) {
            throw new CryptOperatorException(e.getMessage());
        }
    }

    @Override
    public boolean sm4Decrypt(byte[] key, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        return SoftOperatorUtil.sm4Decrypt(key, fileInputStream, fileOutputStream);
    }

    @Override
    public byte[] hmacSM3(byte[] key, byte[] data) {
        return SoftOperatorUtil.hmacWithSm3(key, data);
    }

    @Override
    public byte[] hmacSM3(byte[] key, FileInputStream fileInputStream) {
        return SoftOperatorUtil.hmacWithSm3(key, fileInputStream);
    }

    @Override
    public byte[] sm3(byte[] data) {
        return SoftOperatorUtil.sm3(data);
    }

    @Override
    public byte[] sm3(FileInputStream fileInputStream) {
        return SoftOperatorUtil.sm3(fileInputStream);
    }
}

