/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.bean.KeyInfo;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.keymanage.KeyManageOperator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;

public class SoftKeyManageOperator
implements KeyManageOperator {
    private static final SoftKeyManageOperator softKeyManageOperator = new SoftKeyManageOperator();
    private static final String KEY_FILE_NAME = "softKey.txt";
    CryptoAppKitProperties.Soft soft = CryptoAppKitProperties.getInstance().getSoft();
    KeyCache keyCache = KeyCache.getInstance();

    public static SoftKeyManageOperator getInstance() {
        return softKeyManageOperator;
    }

    @Override
    public List<KeyInfo> initKey() {
        byte[] sm4Key = SoftOperatorUtil.genRandom(16);
        byte[] hmacSm3Key = SoftOperatorUtil.genRandom(32);
        byte[] sm4KeyAndHmacSm3Key = ArrayUtils.addAll((byte[])sm4Key, (byte[])hmacSm3Key);
        byte[] sm2Key = SoftOperatorUtil.sm2Encrypt(this.keyCache.getEncP12Info().getPubKey(), sm4KeyAndHmacSm3Key);
        byte[] sm3 = SoftOperatorUtil.sm3(sm4KeyAndHmacSm3Key);
        byte[] fileContext = ArrayUtils.addAll((byte[])sm2Key, (byte[])sm3);
        try {
            File dir = new File(this.soft.getKeyPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(this.getKeyPath());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileContext);
            fos.close();
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u5b58\u50a8\u5bc6\u94a5\u5230\u672c\u5730\u5931\u8d25");
        }
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setDeviceId(UUID.randomUUID().toString());
        keyInfo.setHsmType(3);
        keyInfo.setEncryptedKeys(Base64.getEncoder().encodeToString(fileContext));
        keyInfo.setKeysHashBySM3(Base64.getEncoder().encodeToString(SoftOperatorUtil.sm3(fileContext)));
        ArrayList<KeyInfo> keyInfoList = new ArrayList<KeyInfo>();
        keyInfoList.add(keyInfo);
        this.keyCache.setKey4SM4(sm4Key);
        this.keyCache.setKey4HmacSM3(hmacSm3Key);
        return keyInfoList;
    }

    @Override
    public byte[] readFile(int length) {
        try {
            String keyPath = this.getKeyPath();
            File file = new File(keyPath);
            if (!file.exists()) {
                return new byte[0];
            }
            FileInputStream fileInputStream = new FileInputStream(keyPath);
            byte[] fileContext = new byte[(int)file.length()];
            fileInputStream.read(fileContext);
            fileInputStream.close();
            return fileContext;
        }
        catch (Exception e) {
            throw new CryptOperatorException("\u4ece\u672c\u5730\u83b7\u53d6\u5bc6\u94a5\u5931\u8d25");
        }
    }

    @Override
    public byte[] sm2Decrypt(byte[] ciphertext) {
        return SoftOperatorUtil.sm2Decrypt(this.keyCache.getEncP12Info().getPriKey(), ciphertext);
    }

    private String getKeyPath() {
        if (this.soft.getKeyPath().endsWith("/") || this.soft.getKeyPath().endsWith("\\")) {
            return this.soft.getKeyPath() + KEY_FILE_NAME;
        }
        return this.soft.getKeyPath() + "/" + KEY_FILE_NAME;
    }
}

