/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.soft;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.sign.SignOperator;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PublicKey;

public class SoftSignOperator
implements SignOperator {
    private static final SoftSignOperator softSignOperator = new SoftSignOperator();
    KeyCache keyCache = KeyCache.getInstance();

    public static SoftSignOperator getInstance() {
        return softSignOperator;
    }

    @Override
    public byte[] sm2Sign(byte[] data) {
        return SoftOperatorUtil.sm2Sign(this.keyCache.getSignP12Info().getPriKey(), data);
    }

    @Override
    public byte[] sm2Sign(FileInputStream fileInputStream) {
        return SoftOperatorUtil.sm2Sign(this.keyCache.getSignP12Info().getPriKey(), fileInputStream);
    }

    @Override
    public boolean sm2SignVerity(FileInputStream fileInputStream, byte[] signData) {
        return SoftOperatorUtil.verifySign(this.keyCache.getSignP12Info().getPubKey(), fileInputStream, signData);
    }

    @Override
    public boolean sm2SignVerity(byte[] orgData, byte[] signData) {
        return SoftOperatorUtil.verifySign(this.keyCache.getSignP12Info().getPubKey(), orgData, signData);
    }

    @Override
    public boolean sm2SignVerity(String signCert, byte[] orgData, byte[] signData, boolean isUseAsn1Encode) {
        try {
            byte[] sign = this.getRealSign(signData, isUseAsn1Encode);
            PublicKey publicKey = SoftOperatorUtil.getPublicKeyByCert(signCert);
            return SoftOperatorUtil.verifySign(publicKey, orgData, sign);
        }
        catch (Exception e) {
            throw new CryptOperatorException("SM2\u5916\u90e8\u516c\u94a5\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    private byte[] getRealSign(byte[] signData, boolean isUseAsn1Encode) throws IOException {
        byte[] sign;
        if (isUseAsn1Encode) {
            sign = signData;
        } else {
            byte[] r = new byte[32];
            System.arraycopy(signData, 0, r, 0, 32);
            byte[] s = new byte[32];
            System.arraycopy(signData, signData.length - 32, s, 0, 32);
            sign = SoftOperatorUtil.derSignatureEncode(r, s);
        }
        return sign;
    }
}

