/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.svs;

import com.xdja.cryptoappkit.device.soft.SoftOperatorUtil;
import com.xdja.cryptoappkit.device.svs.pool.SvsConnection;
import com.xdja.cryptoappkit.device.svs.pool.SvsConnectionProviderImpl;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.svs.api.bean.AlgId;
import com.xdja.svs.api.bean.XvfAttr;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvsUtil {
    private static final Logger logger = LoggerFactory.getLogger(SvsUtil.class);
    private static final String PROVIDER_STR = "BC";
    private static final int SDR_OK = 0;
    private static String SDK_CONF_PATH;
    private static final String SIGN_USER_ID = "1234567812345678";
    private static final int CERT_NORMAL = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sm2Sign(int signKeyIndex, byte[] signKeyValue, byte[] data) {
        SvsConnection connection = SvsConnectionProviderImpl.getInstance().getConnection();
        try {
            logger.info("svs\u7b7e\u540d signKeyIndex:{},session:{}", (Object)signKeyIndex, (Object)connection.getSes()[0]);
            byte[] signature = new byte[128];
            int[] signatureLen = new int[]{72};
            int ret = connection.getXvfApi().signData(connection.getSes()[0], AlgId.SGD_SM3_SM2, signKeyIndex, signKeyValue, signKeyValue.length, data, data.length, signature, signatureLen);
            logger.info("signatureLen:{}", (Object)signatureLen[0]);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + ret);
            }
            byte[] relSign = new byte[signatureLen[0]];
            System.arraycopy(signature, 0, relSign, 0, relSign.length);
            byte[] byArray = relSign;
            return byArray;
        }
        finally {
            SvsConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static byte[] sm2Sign(byte[] appName, int signKeyIndex, byte[] signKeyValue, FileInputStream inputStream) {
        SvsConnection connection = SvsConnectionProviderImpl.getInstance().getConnection();
        try {
            byte[] byArray;
            block23: {
                FileInputStream fileInputStream = inputStream;
                try {
                    int bytesRead;
                    byte[] x509Pubkey;
                    byte[] x509Cert = new byte[2048];
                    int[] x509CertLen = new int[]{2048};
                    int certRet = connection.getXvfApi().exportAppCertByUsage(connection.getSes()[0], appName, appName.length, 0, x509Cert, x509CertLen);
                    if (certRet != 0) {
                        throw new CryptOperatorException(certRet, "SM2\u7b7e\u540d\u5931\u8d25,\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25ret\uff1a" + certRet);
                    }
                    byte[] certByte = new byte[x509CertLen[0]];
                    System.arraycopy(x509Cert, 0, certByte, 0, certByte.length);
                    try (ByteArrayInputStream in = new ByteArrayInputStream(certByte);){
                        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", PROVIDER_STR);
                        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
                        x509Pubkey = cert.getPublicKey().getEncoded();
                    }
                    catch (Exception e) {
                        logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage());
                        throw new CryptOperatorException("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25");
                    }
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                        int initRet = connection.getXvfApi().signDataInit(connection.getSes()[0], AlgId.SGD_SM3_SM2, x509Pubkey, x509Pubkey.length, SIGN_USER_ID.getBytes(), SIGN_USER_ID.getBytes().length, buffer, bytesRead);
                        if (initRet != 0) {
                            throw new CryptOperatorException(initRet, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + initRet);
                        }
                        connection.getXvfApi().signDataUpdate(connection.getSes()[0], AlgId.SGD_SM3_SM2, buffer, bytesRead);
                    }
                    byte[] signature = new byte[128];
                    int[] signatureLen = new int[]{72};
                    int finalRet = connection.getXvfApi().signDataFinal(connection.getSes()[0], AlgId.SGD_SM3_SM2, signKeyIndex, signKeyValue, signKeyValue.length, signature, signatureLen);
                    if (finalRet != 0) {
                        throw new CryptOperatorException(finalRet, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + finalRet);
                    }
                    byte[] relSign = new byte[signatureLen[0]];
                    System.arraycopy(signature, 0, relSign, 0, relSign.length);
                    byArray = relSign;
                    if (fileInputStream == null) break block23;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CryptOperatorException(500, "SM2\u7b7e\u540d\u5931\u8d25,ret\uff1a" + e.getMessage());
                    }
                }
                fileInputStream.close();
            }
            return byArray;
        }
        finally {
            SvsConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sm2SignVerity(byte[] appName, byte[] signature, byte[] data) {
        SvsConnection connection = SvsConnectionProviderImpl.getInstance().getConnection();
        try {
            byte[] x509Cert = new byte[2048];
            int[] x509CertLen = new int[]{2048};
            int certRet = connection.getXvfApi().exportAppCertByUsage(connection.getSes()[0], appName, appName.length, 0, x509Cert, x509CertLen);
            if (certRet != 0) {
                throw new CryptOperatorException(certRet, "SM2\u9a8c\u7b7e\u5931\u8d25,\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25ret\uff1a" + certRet);
            }
            int ret = connection.getXvfApi().verifySignedData(connection.getSes()[0], 1, x509Cert, x509CertLen[0], null, 0, data, data.length, signature, signature.length, XvfAttr.XVF_VERIFY_CERT_OFF);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            SvsConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static boolean sm2SignVerity(byte[] appName, byte[] signature, FileInputStream fileInputStream) {
        SvsConnection connection = SvsConnectionProviderImpl.getInstance().getConnection();
        try {
            int bytesRead;
            byte[] x509Pubkey;
            byte[] x509Cert = new byte[2048];
            int[] x509CertLen = new int[]{2048};
            int certRet = connection.getXvfApi().exportAppCertByUsage(connection.getSes()[0], appName, appName.length, 0, x509Cert, x509CertLen);
            if (certRet != 0) {
                throw new CryptOperatorException(certRet, "SM2\u9a8c\u7b7e\u5931\u8d25,\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25ret\uff1a" + certRet);
            }
            byte[] certByte = new byte[x509CertLen[0]];
            System.arraycopy(x509Cert, 0, certByte, 0, certByte.length);
            try (ByteArrayInputStream in = new ByteArrayInputStream(certByte);){
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509", PROVIDER_STR);
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
                x509Pubkey = cert.getPublicKey().getEncoded();
            }
            catch (Exception e) {
                logger.error("\u8bc1\u4e66\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new CryptOperatorException("\u4ece\u8bc1\u4e66\u4e2d\u89e3\u6790\u516c\u94a5\u5931\u8d25");
            }
            byte[] buffer = new byte[4096];
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                int initRet = connection.getXvfApi().verifySignedDataInit(connection.getSes()[0], AlgId.SGD_SM3_SM2, x509Pubkey, x509Pubkey.length, SIGN_USER_ID.getBytes(), SIGN_USER_ID.getBytes().length, buffer, bytesRead);
                if (initRet != 0) {
                    throw new CryptOperatorException(initRet, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + initRet);
                }
                connection.getXvfApi().verifySignedDataUpdate(connection.getSes()[0], AlgId.SGD_SM3_SM2, buffer, bytesRead);
            }
            int finalRet = connection.getXvfApi().verifySignedDataFinal(connection.getSes()[0], AlgId.SGD_SM3_SM2, 1, x509Cert, x509CertLen[0], null, 0, signature, signature.length, XvfAttr.XVF_VERIFY_CERT_OFF);
            if (finalRet != 0) {
                throw new CryptOperatorException(finalRet, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + finalRet);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new CryptOperatorException(500, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + e.getMessage());
        }
        finally {
            SvsConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    public static boolean sm2SignVerityByExternalCert(String signCert, byte[] data, byte[] signature, boolean isUseAsn1Encode) {
        SvsConnection connection = SvsConnectionProviderImpl.getInstance().getConnection();
        try {
            X509Certificate x509Certificate = SoftOperatorUtil.getCertFromStr(signCert);
            byte[] x509Cert = x509Certificate.getEncoded();
            byte[] sign = SvsUtil.getRealSign(signature, isUseAsn1Encode);
            int ret = connection.getXvfApi().verifySignedData(connection.getSes()[0], 1, x509Cert, x509Cert.length, null, 0, data, data.length, sign, sign.length, 0);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + ret);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | CertificateEncodingException e) {
            throw new CryptOperatorException(500, "SM2\u9a8c\u7b7e\u5931\u8d25,ret\uff1a" + e.getMessage());
        }
        finally {
            SvsConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    private static byte[] getRealSign(byte[] signData, boolean isUseAsn1Encode) throws IOException {
        byte[] sign;
        if (isUseAsn1Encode) {
            sign = signData;
        } else {
            byte[] r = new byte[32];
            System.arraycopy(signData, 0, r, 0, 32);
            byte[] s = new byte[32];
            System.arraycopy(signData, signData.length - 32, s, 0, 32);
            sign = SoftOperatorUtil.derSignatureEncode(r, s);
        }
        return sign;
    }

    public static void setSdkConfPath(String path) {
        SDK_CONF_PATH = path;
    }

    public static String getSdkConfPath() {
        return SDK_CONF_PATH;
    }

    public static boolean validateCert(String cert, int ocsp) {
        SvsConnection connection = SvsConnectionProviderImpl.getInstance().getConnection();
        try {
            X509Certificate x509Certificate = SoftOperatorUtil.getCertFromStr(cert);
            byte[] x509Cert = x509Certificate.getEncoded();
            int[] ocspState = new int[]{10};
            int ret = connection.getXvfApi().validateCert(connection.getSes()[0], x509Cert, x509Cert.length, ocsp, ocspState);
            if (ret != 0) {
                throw new CryptOperatorException(ret, "\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25,ret\uff1a" + ret);
            }
            if (ocsp == 0) {
                boolean bl = ocspState[0] == 0;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (CertificateEncodingException e) {
            throw new CryptOperatorException(500, "\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25,ret\uff1a" + e.getMessage());
        }
        finally {
            SvsConnectionProviderImpl.getInstance().releaseConnection(connection);
        }
    }

    static {
        SvsConnectionProviderImpl.getInstance();
        if (Security.getProvider(PROVIDER_STR) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

