/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.svs.pool;

import com.xdja.cryptoappkit.device.svs.pool.SvsConnection;
import com.xdja.cryptoappkit.device.svs.pool.SvsConnectionProvider;
import com.xdja.cryptoappkit.device.svs.pool.SvsPooledObjectFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvsConnectionProviderImpl
implements SvsConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(SvsConnectionProviderImpl.class);
    private GenericObjectPool<SvsConnection> genericObjectPool;
    private volatile SvsPooledObjectFactory factory = new SvsPooledObjectFactory();

    private SvsConnectionProviderImpl() {
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)this.factory);
        this.initPool();
    }

    private void initPool() {
        int maxTotal = 8;
        int maxIdle = 2;
        int minIdle = 1;
        this.genericObjectPool.setMaxTotal(maxTotal);
        this.genericObjectPool.setMaxIdle(maxIdle);
        this.genericObjectPool.setMinIdle(minIdle);
        this.genericObjectPool.setTestWhileIdle(true);
        this.genericObjectPool.setNumTestsPerEvictionRun(-1);
        this.genericObjectPool.setTimeBetweenEvictionRunsMillis(300000L);
        if (this.factory.isDeviceOpen()) {
            try {
                this.genericObjectPool.preparePool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public SvsConnection getConnection() {
        try {
            if (this.genericObjectPool.getNumWaiters() > 0) {
                // empty if block
            }
            return (SvsConnection)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            logger.error("getConnection error", (Throwable)e);
            throw new RuntimeException("getConnection error", e);
        }
    }

    @Override
    public void releaseConnection(SvsConnection connection) {
        try {
            this.genericObjectPool.returnObject((Object)connection);
            if (this.genericObjectPool.getNumWaiters() > 0) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String methodName = stackTrace[3].getMethodName();
                logger.info("release connection pool: {} getNumIdle={} getNumActive={} getNumWaiters={} getCreatedCount={} getBorrowedCount={} getReturnedCount={}", new Object[]{methodName, this.genericObjectPool.getReturnedCount(), this.genericObjectPool.getNumActive(), this.genericObjectPool.getNumWaiters(), this.genericObjectPool.getCreatedCount(), this.genericObjectPool.getBorrowedCount(), this.genericObjectPool.getReturnedCount()});
            }
        }
        catch (Exception e) {
            logger.error("releaseConnection error", (Throwable)e);
            throw new RuntimeException("releaseConnection error", e);
        }
    }

    public synchronized void clear() {
        this.genericObjectPool.clear();
        this.factory.closeDevice();
    }

    public synchronized void reopen() throws Exception {
        this.clear();
        this.factory.openDevice();
        this.genericObjectPool.preparePool();
    }

    public static synchronized SvsConnectionProviderImpl getInstance() {
        return ConnectionProviderHolder.INSTANCE;
    }

    private static class ConnectionProviderHolder {
        private static final SvsConnectionProviderImpl INSTANCE = new SvsConnectionProviderImpl();

        private ConnectionProviderHolder() {
        }
    }
}

