/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.device.svs.pool;

import com.xdja.cryptoappkit.device.svs.pool.SvsConnection;
import com.xdja.cryptoappkit.device.svs.pool.SvsSdfSDKUtils;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.svs.api.XvfApi;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class SvsPooledObjectFactory
implements PooledObjectFactory<SvsConnection> {
    private volatile XvfApi xvfApi = new XvfApi();
    private volatile long[] dev = new long[]{0L};

    SvsPooledObjectFactory() {
        this.openDevice();
    }

    synchronized boolean isDeviceOpen() {
        return this.dev[0] != 0L;
    }

    synchronized void openDevice() {
        String configPath;
        if (!this.isDeviceOpen() && (configPath = SvsSdfSDKUtils.getConfigPath()) != null) {
            try {
                SvsSdfSDKUtils.initialize(this.xvfApi, this.dev, configPath);
            }
            catch (CryptOperatorException cryptOperatorException) {
                // empty catch block
            }
        }
    }

    synchronized void closeDevice() {
        if (this.dev[0] != 0L) {
            try {
                SvsSdfSDKUtils.closeDevice(this.xvfApi, this.dev);
            }
            catch (CryptOperatorException cryptOperatorException) {
                // empty catch block
            }
        }
        this.dev = new long[]{0L};
    }

    public PooledObject<SvsConnection> makeObject() {
        if (this.dev[0] == 0L) {
            this.openDevice();
        }
        SvsConnection connection = new SvsConnection(this.xvfApi, this.dev);
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(PooledObject<SvsConnection> pooledObject) throws Exception {
        SvsConnection connection = (SvsConnection)pooledObject.getObject();
        if (connection.isConnection()) {
            connection.close();
        }
    }

    public boolean validateObject(PooledObject<SvsConnection> pooledObject) {
        SvsConnection connection = (SvsConnection)pooledObject.getObject();
        return connection.isConnection();
    }

    public void activateObject(PooledObject<SvsConnection> pooledObject) throws Exception {
    }

    public void passivateObject(PooledObject<SvsConnection> pooledObject) throws Exception {
    }
}

