/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptoappkit.domain.model;

import com.xdja.cryptoappkit.device.hsm.HsmCryptOperator;
import com.xdja.cryptoappkit.device.hsm.HsmSignOperator;
import com.xdja.cryptoappkit.device.soft.P12CertOperator;
import com.xdja.cryptoappkit.device.soft.SoftCertOperator;
import com.xdja.cryptoappkit.device.soft.SoftCryptOperator;
import com.xdja.cryptoappkit.device.soft.SoftSignOperator;
import com.xdja.cryptoappkit.device.svs.SvsCertOperator;
import com.xdja.cryptoappkit.device.svs.SvsSignOperator;
import com.xdja.cryptoappkit.device.usbkey.UsbKeySignOperator;
import com.xdja.cryptoappkit.domain.bean.CryptoAppKitProperties;
import com.xdja.cryptoappkit.domain.bean.KeyCache;
import com.xdja.cryptoappkit.domain.exception.CryptOperatorException;
import com.xdja.cryptoappkit.domain.operator.cert.CertOperator;
import com.xdja.cryptoappkit.domain.operator.crypt.CryptOperator;
import com.xdja.cryptoappkit.domain.operator.sign.SignOperator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class CryptService {
    CryptOperator cryptOperator;
    SignOperator signOperator;
    CertOperator certOperator;
    KeyCache keyCache = KeyCache.getInstance();
    CryptoAppKitProperties cryptoAppKitProperties = CryptoAppKitProperties.getInstance();

    public CryptService() {
        if (1 == this.cryptoAppKitProperties.getHsmType()) {
            if (this.cryptoAppKitProperties.isUseSvs()) {
                this.certOperator = SvsCertOperator.getInstance();
                this.signOperator = SvsSignOperator.getInstance();
            } else {
                this.certOperator = SoftCertOperator.getInstance();
                this.signOperator = UsbKeySignOperator.getInstance();
            }
            this.cryptOperator = SoftCryptOperator.getInstance();
        } else if (2 == this.cryptoAppKitProperties.getHsmType()) {
            if (this.cryptoAppKitProperties.isUseSvs()) {
                this.certOperator = SvsCertOperator.getInstance();
                this.signOperator = SvsSignOperator.getInstance();
            } else {
                this.certOperator = SoftCertOperator.getInstance();
                this.signOperator = HsmSignOperator.getInstance();
            }
            this.cryptOperator = HsmCryptOperator.getInstance();
        } else {
            if (this.cryptoAppKitProperties.isUseSvs()) {
                this.certOperator = SvsCertOperator.getInstance();
                this.signOperator = SvsSignOperator.getInstance();
            } else {
                this.certOperator = SoftCertOperator.getInstance();
                this.signOperator = SoftSignOperator.getInstance();
            }
            this.cryptOperator = SoftCryptOperator.getInstance();
            if (StringUtils.isNotEmpty((CharSequence)this.cryptoAppKitProperties.getSoft().getSignKeyStoreFile()) && StringUtils.isNotEmpty((CharSequence)this.cryptoAppKitProperties.getSoft().getEncKeyStoreFile())) {
                try {
                    P12CertOperator.getInstance().initCert();
                }
                catch (Exception e) {
                    throw new CryptOperatorException(e.getMessage());
                }
            } else {
                throw new CryptOperatorException("p12\u7b7e\u540d\u548c\u52a0\u5bc6\u8bc1\u4e66\u672a\u914d\u7f6e");
            }
        }
    }

    public String sm2Sign(String data) {
        byte[] sign = this.signOperator.sm2Sign(data.getBytes());
        return Base64.getEncoder().encodeToString(sign);
    }

    public byte[] sm2Sign(byte[] data) {
        return this.signOperator.sm2Sign(data);
    }

    public byte[] sm2Sign(FileInputStream fileInputStream) {
        return this.signOperator.sm2Sign(fileInputStream);
    }

    public boolean sm2SignVerity(String orgData, String sign) {
        return this.signOperator.sm2SignVerity(orgData.getBytes(), Base64.getDecoder().decode(sign));
    }

    public boolean sm2SignVerity(byte[] orgData, byte[] sign) {
        return this.signOperator.sm2SignVerity(orgData, sign);
    }

    public boolean sm2SignVerity(FileInputStream fileInputStream, byte[] signData) {
        return this.signOperator.sm2SignVerity(fileInputStream, signData);
    }

    public boolean sm2SignVerity(String signCert, String orgData, String sign, boolean signedByXdjaCardManage) {
        return this.signOperator.sm2SignVerity(signCert, orgData.getBytes(), Base64.getDecoder().decode(sign), !signedByXdjaCardManage);
    }

    public String sm4Encrypt(String data) {
        byte[] cipherText = this.cryptOperator.sm4Encrypt(this.keyCache.getKey4SM4(), data.getBytes());
        return Base64.getEncoder().encodeToString(cipherText);
    }

    public byte[] sm4Encrypt(byte[] data) {
        byte[] cipherText = this.cryptOperator.sm4Encrypt(this.keyCache.getKey4SM4(), data);
        return cipherText;
    }

    public boolean sm4Encrypt(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        return this.cryptOperator.sm4Encrypt(this.keyCache.getKey4SM4(), fileInputStream, fileOutputStream);
    }

    public String sm4Decrypt(String cipherText) {
        byte[] data = this.cryptOperator.sm4Decrypt(this.keyCache.getKey4SM4(), Base64.getDecoder().decode(cipherText));
        return new String(data);
    }

    public byte[] sm4Decrypt(byte[] cipherText) {
        return this.cryptOperator.sm4Decrypt(this.keyCache.getKey4SM4(), cipherText);
    }

    public boolean sm4Decrypt(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        return this.cryptOperator.sm4Decrypt(this.keyCache.getKey4SM4(), fileInputStream, fileOutputStream);
    }

    public String hmacSM3(String data) {
        byte[] hash = this.cryptOperator.hmacSM3(this.keyCache.getKey4HmacSM3(), data.getBytes());
        return Base64.getEncoder().encodeToString(hash);
    }

    public byte[] hmacSM3(byte[] data) {
        return this.cryptOperator.hmacSM3(this.keyCache.getKey4HmacSM3(), data);
    }

    public byte[] hmacSM3(FileInputStream fileInputStream) {
        return this.cryptOperator.hmacSM3(this.keyCache.getKey4HmacSM3(), fileInputStream);
    }

    public String sm3(String data) {
        byte[] hash = this.cryptOperator.sm3(data.getBytes());
        return Base64.getEncoder().encodeToString(hash);
    }

    public byte[] sm3(byte[] data) {
        return this.cryptOperator.sm3(data);
    }

    public byte[] sm3(FileInputStream fileInputStream) {
        return this.cryptOperator.sm3(fileInputStream);
    }

    public boolean certVerity(String cert) {
        return this.certOperator.certVerify(cert);
    }
}

