/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.AgentFrontend;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.consts.AgentType;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.Packet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AgentConnection> agentConnectionMap = new HashMap<String, AgentConnection>();
    private final AgentFrontend agentFrontend;
    private AgentMeta meta;

    public Agent(AgentFrontend agentFrontend, AgentMeta agentMeta) {
        this.agentFrontend = agentFrontend;
        this.meta = agentMeta;
    }

    public void applyNewConfig() {
        for (AgentConnection conn : this.agentConnectionMap.values()) {
            conn.applyNewConfig();
        }
    }

    public EngineParams getEngineParams() {
        return this.agentFrontend.getEngineParams();
    }

    public void addConnection(AgentConnection connection) {
        this.agentConnectionMap.put(connection.id(), connection);
    }

    public Boolean containsConnection(String id) {
        return this.agentConnectionMap.containsKey(id);
    }

    public AgentMeta getAgentMeta() {
        return this.meta;
    }

    public Integer getAgentPort() {
        return this.meta.getAgentPort();
    }

    public Integer getAgentType() {
        return this.meta.getAgentType();
    }

    public Integer getConnectedCount() {
        return this.agentConnectionMap.size();
    }

    public AgentConnection getConnection(String id) {
        return this.agentConnectionMap.get(id);
    }

    public Boolean isRouteLocal() {
        return this.meta.isRouteLocal();
    }

    public void onReceiveFromRoute(ChannelPacket bean) {
        AgentConnection agentConnection = this.agentConnectionMap.get(bean.getChannelId());
        if (agentConnection != null) {
            agentConnection.onReceiveFromRoute(bean);
        }
    }

    public void removeConnection(AgentConnection connection) {
        this.agentConnectionMap.remove(connection.id());
    }

    public void sendToRoute(Packet one) {
        one.setLocal(this.isRouteLocal());
        this.agentFrontend.sendToRoute(one);
    }

    public void sendToRouteRemote(Packet one) {
        one.setLocal(false);
        this.agentFrontend.sendToRoute(one);
    }

    public void closeAllConnection() {
        this.logger.info("shutdown agentService {} , port {} , routeLocal {}!", new Object[]{this.getAgentMeta().getId(), this.getAgentPort(), this.getAgentMeta().isRouteLocal()});
        for (AgentConnection conn : this.agentConnectionMap.values()) {
            conn.close();
        }
    }

    public String toDesc() {
        return String.format("id:%s,type:%s,port:%s", this.meta.getId(), AgentType.toDesc(this.meta.getAgentType()), this.meta.getAgentPort());
    }

    public void resetMeta(AgentMeta newCfg) {
        this.meta = newCfg;
    }
}

