/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.engine.IConnPacketListener;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.DataPacket;
import com.xdja.csagent.engine.packet.FeedbackPacket;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentConnection {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Channel channel;
    private final String id;
    protected volatile boolean partnerClosed = false;
    private IConnPacketListener connPacketListener;
    private Set<IConnectionPlugin> connectionPlugins;

    public Set<IConnectionPlugin> getConnectionPlugins() {
        if (this.connectionPlugins != null) {
            return this.connectionPlugins;
        }
        return Collections.emptySet();
    }

    public AgentConnection(String id, Channel channel) {
        this.id = id;
        this.channel = channel;
        this.connPacketListener = this.newConnPacketListener();
    }

    public abstract void applyNewConfig();

    public Channel channel() {
        return this.channel;
    }

    public void close() {
        this.channel.close();
    }

    public String getRemoteAddress() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getHostName();
    }

    public Integer getRemotePort() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getPort();
    }

    public String id() {
        return this.id;
    }

    public abstract Boolean isRouteLocal();

    protected abstract IConnPacketListener newConnPacketListener();

    public final void onReceiveFromRoute(ChannelPacket packet) {
        if (packet instanceof FeedbackPacket) {
            FeedbackPacket feedback = (FeedbackPacket)packet;
            byte feedbackType = feedback.getType();
            if (feedbackType == 2) {
                this.logger.trace("feedback: connect failure");
                this.connPacketListener.onPartnerConnectFailure(this, feedback);
            } else if (feedbackType == 5) {
                this.logger.trace("feedback: write data success");
                this.connPacketListener.onPartnerWriteSuccess(this, feedback);
            } else if (feedbackType == 4) {
                this.logger.trace("feedback: write data failure");
                this.connPacketListener.onPartnerWriteFailure(this, feedback);
            } else if (feedbackType == 1) {
                this.logger.trace("feedback: connection close");
                this.connPacketListener.onPartnerConnectClose(this, feedback);
            } else if (feedbackType == 3) {
                this.logger.trace("feedback: connect success");
                this.connPacketListener.onPartnerConnectSuccess(this, feedback);
            }
        } else if (packet instanceof DataPacket) {
            DataPacket data = (DataPacket)packet;
            this.logger.trace("feedback: data {} byte", (Object)data.getData().length);
            this.connPacketListener.receivePartnerData(this, data);
        }
    }

    public void setConnectionPlugins(Set<IConnectionPlugin> connectionPlugins) {
        this.connectionPlugins = connectionPlugins;
    }
}

