/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.engine;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.AgentRoute;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.IWidget;
import com.xdja.csagent.engine.PortListenManager;
import com.xdja.csagent.engine.bean.EngineParams;
import com.xdja.csagent.engine.consts.PacketSource;
import com.xdja.csagent.engine.packet.ChannelPacket;
import com.xdja.csagent.engine.packet.Packet;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AgentFrontend
implements IWidget,
IRoutePacketListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Agent> agentServiceMap = new HashMap<String, Agent>();
    private PortListenManager portListenManager;
    private EngineParams engineParams;
    private AgentRoute route;

    public AgentFrontend(EngineParams engineParams) {
        this.portListenManager = new PortListenManager(engineParams);
        this.engineParams = engineParams;
    }

    public void addAgentService(AgentMeta agentMeta) throws Exception {
        if (!this.agentServiceMap.containsKey(agentMeta.getId())) {
            Agent agent = new Agent(this, agentMeta);
            this.portListenManager.registerListen(agent);
            this.agentServiceMap.put(agentMeta.getId(), agent);
        }
    }

    public void addConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.portListenManager.addConnectionPlugin(connectionPlugin);
    }

    public Agent getAgentService(String id) {
        return this.agentServiceMap.get(id);
    }

    public EngineParams getEngineParams() {
        return this.engineParams;
    }

    public Set<String> getAgentServiceIds() {
        return this.agentServiceMap.keySet();
    }

    @Override
    public boolean isReceive(Packet bean) {
        if (bean instanceof ChannelPacket) {
            return ((ChannelPacket)bean).getSource() != PacketSource.Frontend;
        }
        return false;
    }

    @Override
    public void init(AgentRoute route) {
        Assert.isNull((Object)this.route);
        this.route = route;
    }

    @Override
    public void close() {
        this.logger.info("close AgentFrontend begin");
        for (Agent one : this.agentServiceMap.values()) {
            one.closeAllConnection();
        }
        this.portListenManager.shutdown();
        this.logger.debug("close AgentFrontend over");
    }

    @Override
    public void onReceiveFromRoute(Packet packet, AgentRoute route) {
        ChannelPacket bean = (ChannelPacket)packet;
        for (Agent one : this.agentServiceMap.values()) {
            if (!one.containsConnection(bean.getChannelId()).booleanValue()) continue;
            one.onReceiveFromRoute(bean);
            return;
        }
        this.logger.warn("Ignore packet for {} !! class name is {}", (Object)bean.getChannelId(), (Object)bean.getClass().getSimpleName());
    }

    public void removeAgentService(String id) throws Exception {
        Agent agent = this.agentServiceMap.get(id);
        Assert.notNull((Object)agent, (String)("id\u4e3a" + id + "\u7684\u4ee3\u7406\u670d\u52a1\u4e0d\u5b58\u5728"));
        agent.closeAllConnection();
        this.portListenManager.unregisterListen(agent);
        this.agentServiceMap.remove(id);
    }

    public void removeConnectionPlugin(IConnectionPlugin connectionPlugin) {
        this.portListenManager.removeConnectionPlugin(connectionPlugin);
    }

    void sendToRoute(Packet one) {
        if (one instanceof ChannelPacket) {
            ((ChannelPacket)one).setSource(PacketSource.Frontend);
        }
        if (this.route != null && (one.isLocal() || this.route.isAvailable())) {
            this.route.send(one);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isRunning() {
        return this.portListenManager.isRunning();
    }

    @Override
    public void startup() throws Exception {
        this.logger.info("Start AgentFrontend....");
        this.portListenManager.startup();
        this.logger.debug("Start AgentFrontend Over!!!");
    }

    public void updateAgentMeta(AgentMeta newCfg) throws Exception {
        Agent agent = this.agentServiceMap.get(newCfg.getId());
        if (agent != null) {
            boolean needRestart = false;
            if (this.agentPortChange(newCfg, agent) || this.agentTypeChange(newCfg, agent) || this.routeLocalChange(newCfg, agent)) {
                needRestart = true;
            }
            agent.resetMeta(newCfg);
            if (needRestart) {
                agent.closeAllConnection();
                this.portListenManager.unregisterListen(agent);
                this.portListenManager.registerListen(agent);
            } else {
                agent.applyNewConfig();
            }
        }
    }

    private boolean routeLocalChange(AgentMeta newCfg, Agent agent) {
        return !agent.isRouteLocal().equals(newCfg.isRouteLocal());
    }

    private boolean agentTypeChange(AgentMeta newCfg, Agent agent) {
        return !agent.getAgentType().equals(newCfg.getAgentType());
    }

    private boolean agentPortChange(AgentMeta newCfg, Agent agent) {
        return !agent.getAgentPort().equals(newCfg.getAgentPort());
    }
}

